/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FrameBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TimberFrameItem
extends BlockItem {
    public TimberFrameItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState frame;
        BlockPos pos;
        Level world;
        BlockState clicked;
        Player player = context.getPlayer();
        if (CommonConfigs.Building.SWAP_TIMBER_FRAME.get().booleanValue() && player != null && player.isShiftKeyDown() && Utils.mayPerformBlockAction((Player)player, (BlockPos)context.getClickedPos(), (ItemStack)context.getItemInHand()) && FrameBlockTile.isValidBlock(clicked = (world = context.getLevel()).getBlockState(pos = context.getClickedPos()), pos, world) && (frame = this.getBlock().getStateForPlacement(new BlockPlaceContext(context))) != null) {
            world.setBlockAndUpdate(pos, frame);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof FrameBlockTile) {
                FrameBlockTile tile = (FrameBlockTile)blockEntity;
                SoundType s = frame.getSoundType();
                tile.acceptBlock(clicked);
                world.playSound(player, pos, s.getPlaceSound(), SoundSource.BLOCKS, (s.getVolume() + 1.0f) / 2.0f, s.getPitch() * 0.8f);
                if (!player.isCreative() && !world.isClientSide()) {
                    context.getItemInHand().shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.timber_frame").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }
}

