/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSlimedMessage;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ISlimeable {
    @Unique
    int supp$slimedTicks = 0;

    protected LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public int supp$getSlimedTicks() {
        return this.supp$slimedTicks;
    }

    @Override
    public void supp$setSlimedTicks(int newSlimedTicks, boolean sync) {
        block4: {
            int old;
            block5: {
                old = this.supp$getSlimedTicks();
                this.supp$slimedTicks = newSlimedTicks;
                if (!sync || this.level().isClientSide) break block4;
                LivingEntityMixin livingEntityMixin = this;
                if (!(livingEntityMixin instanceof ServerPlayer)) break block5;
                ServerPlayer p = (ServerPlayer)livingEntityMixin;
                if (p.connection == null) break block4;
            }
            NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)this, (Message)new ClientBoundSyncSlimedMessage(this.getId(), this.supp$getSlimedTicks()));
            if (newSlimedTicks > old) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.SLIME_SPLAT.get(), this.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    @Shadow
    public abstract boolean onClimbable();

    @Shadow
    public abstract boolean isSuppressingSlidingDownLadder();

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @ModifyReturnValue(method={"getJumpBoostPower()F"}, at={@At(value="RETURN")})
    private float suppl$checkOverencumbered(float original) {
        CommonConfigs.SlimedJumpMode mode;
        MobEffectInstance effect = this.getEffect((Holder<MobEffect>)ModRegistry.OVERENCUMBERED.getHolder());
        if (effect != null && effect.getAmplifier() > 0) {
            original -= 0.1f;
        }
        if (this.supp$getSlimedTicks() > 0 && (mode = CommonConfigs.Tweaks.HINDERS_JUMP.get()).isOn(this.level())) {
            original -= 0.1f;
        }
        return original;
    }

    @Inject(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void suppl$checkOnRope(Vec3 motion, CallbackInfoReturnable<Vec3> info) {
        BlockState b;
        if (this.onClimbable() && CommonConfigs.Functional.ROPE_SLIDE.get().booleanValue() && (b = this.getBlockStateOn()).is(ModTags.FAST_FALL_ROPES)) {
            this.fallDistance = 0.0f;
            double x = Mth.clamp((double)motion.x, (double)-0.15f, (double)0.15f);
            double z = Mth.clamp((double)motion.z, (double)-0.15f, (double)0.15f);
            double y = motion.y();
            if (this.isSuppressingSlidingDownLadder() && y < 0.0 && this instanceof Player) {
                y = 0.0;
            }
            info.setReturnValue((Object)new Vec3(x, y, z));
        }
    }

    @Inject(method={"triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isUsingItem()Z")})
    private void suppl$eatFromLunchBasket(ItemStack stack, int amount, CallbackInfo ci, @Local(argsOnly=true) LocalRef<ItemStack> food) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(ModComponents.LUNCH_BASKET_CONTENT.get());
        if (data != null && data.canEatFrom()) {
            food.set((Object)data.getSelected());
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void suppl$slimeTick(CallbackInfo ci) {
        ISlimeable.tickEntity((LivingEntity)this);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void suppl$readSlimedTicks(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("supplementaries:slimed_ticks")) {
            this.supp$setSlimedTicks(compound.getInt("supplementaries:slimed_ticks"), true);
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void suppl$writeSlimedTicks(CompoundTag compound, CallbackInfo ci) {
        if (this.supp$getSlimedTicks() > 0) {
            compound.putInt("supplementaries:slimed_ticks", this.supp$getSlimedTicks());
        }
    }
}

