/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class AddChargeRecipe
extends class_1852 {
    private final class_1856 targetItem;
    private final class_1856 targetCharge;
    private final class_1792 result;
    private final int chargesPerItem;
    private final boolean canOverflow;

    public AddChargeRecipe(class_7710 category, class_1856 arrow, class_1856 rope, class_1792 result, int chargesPerItem, boolean canOverflow) {
        super(category);
        this.targetItem = arrow;
        this.targetCharge = rope;
        this.result = result;
        this.chargesPerItem = chargesPerItem;
        this.canOverflow = canOverflow;
    }

    public boolean matches(class_9694 inv, class_1937 worldIn) {
        class_1799 arrow = null;
        class_1799 rope = null;
        int newTotalCharges = 0;
        for (int i = 0; i < inv.method_59983(); ++i) {
            class_1799 stack = inv.method_59984(i);
            if (this.targetItem.method_8093(stack)) {
                if (arrow != null) {
                    return false;
                }
                arrow = stack;
                newTotalCharges += ((Integer)stack.method_57825(ModComponents.CHARGES.get(), (Object)0)).intValue();
                continue;
            }
            if (this.targetCharge.method_8093(stack)) {
                rope = stack;
                newTotalCharges += this.chargesPerItem;
                continue;
            }
            if (stack.method_7960()) continue;
            return false;
        }
        return arrow != null && rope != null && (this.canOverflow || newTotalCharges <= (Integer)this.result.method_7854().method_57825(ModComponents.MAX_CHARGES.get(), (Object)0));
    }

    public class_1799 assemble(class_9694 inv, class_7225.class_7874 access) {
        int newTotalCharges = 0;
        class_1799 arrow = null;
        for (int i = 0; i < inv.method_59983(); ++i) {
            class_1799 stack = inv.method_59984(i);
            if (this.targetItem.method_8093(stack)) {
                arrow = stack;
                newTotalCharges += ((Integer)stack.method_57825(ModComponents.CHARGES.get(), (Object)0)).intValue();
                continue;
            }
            if (!this.targetCharge.method_8093(stack)) continue;
            newTotalCharges += this.chargesPerItem;
        }
        class_1799 returnArrow = arrow.method_56701((class_1935)this.result, 1);
        returnArrow.method_57379(ModComponents.CHARGES.get(), (Object)Math.min(newTotalCharges, (Integer)returnArrow.method_57825(ModComponents.MAX_CHARGES.get(), (Object)0)));
        return returnArrow;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.ROPE_ARROW_ADD.get();
    }

    public static class Serializer
    implements class_1865<AddChargeRecipe> {
        private static final MapCodec<AddChargeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_3955::method_45441), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(recipe -> recipe.targetItem), (App)class_1856.field_46095.fieldOf("charge").forGetter(recipe -> recipe.targetCharge), (App)class_7923.field_41178.method_39673().fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("charges_per_item", (Object)1).forGetter(recipe -> recipe.chargesPerItem), (App)Codec.BOOL.optionalFieldOf("can_overfill", (Object)false).forGetter(recipe -> recipe.canOverflow)).apply((Applicative)instance, AddChargeRecipe::new));
        private static final class_9139<class_9129, AddChargeRecipe> STREAM_CODEC = class_9139.method_58025((class_9139)class_7710.field_48353, class_3955::method_45441, (class_9139)class_1856.field_48355, recipe -> recipe.targetItem, (class_9139)class_1856.field_48355, recipe -> recipe.targetCharge, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), recipe -> recipe.result, (class_9139)class_9135.field_48550, recipe -> recipe.chargesPerItem, (class_9139)class_9135.field_48547, recipe -> recipe.canOverflow, AddChargeRecipe::new);

        public MapCodec<AddChargeRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, AddChargeRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

