/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.StatueEntityModel;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.PedestalBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.StatueBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_918;

public class StatueBlockTileRenderer
implements class_827<StatueBlockTile> {
    protected final class_918 itemRenderer = class_310.method_1551().method_1480();
    private final StatueEntityModel model;
    private final class_776 blockRenderer;
    private final class_898 entityRenderer;
    private boolean slim = false;

    public StatueBlockTileRenderer(class_5614.class_5615 context) {
        this.model = new StatueEntityModel(context);
        this.blockRenderer = class_310.method_1551().method_1541();
        this.entityRenderer = class_310.method_1551().method_1561();
    }

    protected boolean canRenderName(StatueBlockTile tile) {
        class_2338 hitPos;
        class_2338 pos;
        class_239 hit;
        if (class_310.method_1498() && tile.getPlayerSkin() != null && (hit = class_310.method_1551().field_1765) != null && hit.method_17783() == class_239.class_240.field_1332 && (pos = tile.method_11016()).equals((Object)(hitPos = class_2338.method_49638((class_2374)hit.method_17784())))) {
            double d0 = this.entityRenderer.method_3959((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            return d0 < 256.0;
        }
        return false;
    }

    public int method_33893() {
        return 60;
    }

    public static class_2960 getPlayerSkin(GameProfile gameProfile) {
        return StatueBlockTileRenderer.getPlayerSkinAndSlim(gameProfile, s -> {});
    }

    public static class_2960 getPlayerSkinAndSlim(GameProfile gameProfile, Consumer<Boolean> slimSkinSetter) {
        if (!gameProfile.isComplete()) {
            return new class_2960("minecraft:textures/entity/steve.png");
        }
        class_1071 skinManager = class_310.method_1551().method_1582();
        Map skinCache = skinManager.method_4654(gameProfile);
        if (skinCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture texture = (MinecraftProfileTexture)skinCache.get(MinecraftProfileTexture.Type.SKIN);
            String s = texture.getMetadata("model");
            boolean slim = s != null && !s.equals("default");
            slimSkinSetter.accept(slim);
            return skinManager.method_4656(texture, MinecraftProfileTexture.Type.SKIN);
        }
        slimSkinSetter.accept(false);
        return class_1068.method_4648((UUID)gameProfile.getId());
    }

    private boolean isSkinSlim(GameProfile gameProfile) {
        return gameProfile != null && gameProfile.getId() != null && (gameProfile.getId().hashCode() & 1) == 1;
    }

    public void render(StatueBlockTile tile, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        String name;
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        GameProfile playerInfo = tile.getPlayerSkin();
        if (this.canRenderName(tile) && (name = playerInfo.getName()) != null) {
            PedestalBlockTileRenderer.renderName((class_2561)class_2561.method_43470((String)name), 0.875f, poseStack, bufferIn, combinedLightIn);
        }
        class_2960 resourceLocation = playerInfo == null ? ModTextures.STATUE : StatueBlockTileRenderer.getPlayerSkinAndSlim(playerInfo, s -> {
            this.slim = s;
        });
        class_2350 dir = tile.getDirection();
        poseStack.method_22907(RotHlpr.rot((class_2350)dir));
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22904(0.0, -0.25, 0.0);
        class_1921 renderType = class_1921.method_23580((class_2960)resourceLocation);
        StatueBlockTile.StatuePose pose = tile.getPose();
        class_1799 stack = tile.getDisplayedItem();
        if (MiscUtils.FESTIVITY.isHalloween()) {
            this.model.head.field_3665 = false;
            this.model.hat.field_3665 = false;
            if (pose == StatueBlockTile.StatuePose.STANDING) {
                pose = StatueBlockTile.StatuePose.HOLDING;
                stack = class_1802.field_8693.method_7854();
            } else {
                poseStack.method_22903();
                poseStack.method_22905(-0.625f, -0.625f, 0.625f);
                poseStack.method_22904(0.0, 0.1875, 0.0);
                this.itemRenderer.method_23178(class_1802.field_17519.method_7854(), class_811.field_4319, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, tile.method_10997(), 0);
                poseStack.method_22909();
            }
        } else {
            this.model.head.field_3665 = true;
            this.model.hat.field_3665 = true;
        }
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.499f, 0.5f);
        class_4588 buffer = bufferIn.getBuffer(renderType);
        this.model.setupAnim(tile.method_10997().method_8510(), partialTicks, dir, pose, tile.isWaving(), this.slim);
        this.model.method_2828(poseStack, buffer, combinedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
        this.slim = false;
        switch (pose) {
            case STANDING: {
                break;
            }
            case CANDLE: {
                poseStack.method_22905(1.0f, -1.0f, -1.0f);
                poseStack.method_22904(-0.5, -0.6875, -0.3125);
                this.blockRenderer.method_3353(tile.hasCandle(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
                break;
            }
            default: {
                poseStack.method_22905(-0.5f, -0.5f, 0.5f);
                class_1087 itemModel = this.itemRenderer.method_4019(stack, tile.method_10997(), null, 0);
                if (pose == StatueBlockTile.StatuePose.SWORD) {
                    poseStack.method_22904(-0.35, -1.0625, 0.0);
                    poseStack.method_22907(RotHlpr.Z135);
                } else if (pose == StatueBlockTile.StatuePose.TOOL) {
                    poseStack.method_22904(-0.4, -1.25, 0.0);
                    poseStack.method_22907(RotHlpr.Z135);
                }
                poseStack.method_22904(0.0, -0.5, -0.5);
                if (pose.isGlobe()) {
                    if (GlobeBlockTileRenderer.INSTANCE == null) break;
                    boolean sepia = pose == StatueBlockTile.StatuePose.SEPIA_GLOBE;
                    Pair<GlobeManager.Model, class_2960> pair = stack.method_7938() ? GlobeManager.Type.getModelAndTexture(stack.method_7964().getString()) : Pair.of((Object)((Object)GlobeManager.Model.GLOBE), null);
                    GlobeBlockTileRenderer.INSTANCE.renderGlobe(pair, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, sepia, tile.method_10997());
                    break;
                }
                this.itemRenderer.method_23179(stack, class_811.field_4319, true, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, itemModel);
            }
        }
        poseStack.method_22909();
    }
}

