/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.Nullable;

public class PlaceableBookManager {
    private static final Map<String, BookType> BY_NAME = new HashMap<String, BookType>();
    private static final Multimap<class_1792, BookType> BY_ITEM = HashMultimap.create();

    public static void register(BookType type, @Nullable class_1792 item) {
        if (item != null) {
            BY_ITEM.put((Object)item, (Object)type);
            BY_NAME.put(type.name(), type);
        }
    }

    public static void registerDefault(class_1767 color) {
        PlaceableBookManager.register(new BookType(color), class_1802.field_8529);
    }

    public static void registerDefault(class_1767 color, int angle) {
        PlaceableBookManager.register(new BookType(color, (float)angle, false), class_1802.field_8529);
    }

    public static void registerDefault(String name, int color) {
        PlaceableBookManager.register(new BookType(name, color, false), class_1802.field_8529);
    }

    public static void setup() {
        PlaceableBookManager.registerDefault(class_1767.field_7957, 1);
        PlaceableBookManager.registerDefault(class_1767.field_7952, 1);
        PlaceableBookManager.registerDefault(class_1767.field_7963, 1);
        PlaceableBookManager.registerDefault(class_1767.field_7967);
        PlaceableBookManager.registerDefault(class_1767.field_7944);
        PlaceableBookManager.registerDefault(class_1767.field_7946);
        PlaceableBookManager.registerDefault(class_1767.field_7947);
        PlaceableBookManager.registerDefault(class_1767.field_7961);
        PlaceableBookManager.registerDefault("green", 3129655);
        PlaceableBookManager.registerDefault("cyan", 1502399);
        PlaceableBookManager.registerDefault(class_1767.field_7951);
        PlaceableBookManager.registerDefault(class_1767.field_7966);
        PlaceableBookManager.registerDefault(class_1767.field_7945);
        PlaceableBookManager.registerDefault(class_1767.field_7958);
        PlaceableBookManager.registerDefault(class_1767.field_7954);
        PlaceableBookManager.registerDefault(class_1767.field_7964);
        PlaceableBookManager.register(new BookType("enchanted", 0, 1.0f, true), class_1802.field_8598);
        PlaceableBookManager.register(new BookType("and_quill", 0, 1.0f, false), class_1802.field_8674);
        PlaceableBookManager.register(new BookType("written", 0, 1.0f, false), class_1802.field_8360);
        PlaceableBookManager.register(new BookType("tattered", 0, 1.0f, false), null);
        PlaceableBookManager.register(new BookType("tome", 0, 1.0f, true), CompatObjects.TOME.get());
        PlaceableBookManager.register(new BookType("gene", 0, 1.0f, false), CompatObjects.GENE_BOOK.get());
    }

    public static BookType rand(Random r) {
        ArrayList<BookType> all = PlaceableBookManager.getAll();
        return all.get(r.nextInt(all.size()));
    }

    public static ArrayList<BookType> getAll() {
        return new ArrayList<BookType>(BY_ITEM.values());
    }

    public static BookType getByName(String name) {
        BookType b = BY_NAME.get(name);
        if (b == null) {
            return BY_NAME.get("brown");
        }
        return b;
    }

    public static ArrayList<BookType> getByItem(class_1799 stack) {
        if (AntiqueInkItem.hasAntiqueInk(stack)) {
            return new ArrayList<BookType>(List.of(PlaceableBookManager.getByName("tattered")));
        }
        class_1792 item = stack.method_7909();
        if (Utils.getID((class_1792)item).method_12836().equals("inspirations")) {
            String colName = Utils.getID((class_1792)item).method_12832().replace("_book", "");
            return new ArrayList<BookType>(List.of(PlaceableBookManager.getByName(colName)));
        }
        return new ArrayList<BookType>(BY_ITEM.get((Object)item));
    }
}

