/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxBlockTile
extends ItemDisplayTile
implements IBlockHolder,
IExtraModelDataProvider {
    public static final ModelDataKey<class_2680> FLOWER_0 = ModBlockProperties.FLOWER_0;
    public static final ModelDataKey<class_2680> FLOWER_1 = ModBlockProperties.FLOWER_1;
    public static final ModelDataKey<class_2680> FLOWER_2 = ModBlockProperties.FLOWER_2;
    private final class_2680[] flowerStates = new class_2680[]{class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564(), class_2246.field_10124.method_9564()};

    public FlowerBoxBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.FLOWER_BOX_TILE.get(), pos, state, 3);
    }

    public class_2680 getHeldBlock(int index) {
        return this.flowerStates[index];
    }

    public boolean setHeldBlock(class_2680 state, int index) {
        if (index >= 0 && index < 3) {
            this.flowerStates[index] = state;
        }
        return false;
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (this.field_11863 instanceof class_3218) {
            this.setBlockFromItem(slot, stack.method_7909());
            int newLight = Math.max(Math.max(ForgeHelper.getLightEmission((class_2680)this.getHeldBlock(), (class_1937)this.field_11863, (class_2338)this.field_11867), ForgeHelper.getLightEmission((class_2680)this.getHeldBlock(1), (class_1937)this.field_11863, (class_2338)this.field_11867)), ForgeHelper.getLightEmission((class_2680)this.getHeldBlock(2), (class_1937)this.field_11863, (class_2338)this.field_11867));
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
        }
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLOWER_0, (Object)this.flowerStates[0]).with(FLOWER_1, (Object)this.flowerStates[1]).with(FLOWER_2, (Object)this.flowerStates[2]);
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867).method_989(0.0, 0.25, 0.0);
    }

    public void updateClientVisualsOnLoad() {
        for (int n = 0; n < this.flowerStates.length; ++n) {
            class_1792 item = this.method_5438(n).method_7909();
            this.setBlockFromItem(n, item);
        }
        this.requestModelReload();
    }

    private void setBlockFromItem(int n, class_1792 item) {
        class_2248 b = null;
        if (item instanceof class_1747) {
            class_1747 bi = (class_1747)item;
            b = bi.method_7711();
        } else if (CompatHandler.DYNAMICTREES) {
            b = CompatHandler.DynTreesGetOptionalDynamicSapling(item, this.field_11863, this.field_11867);
        }
        if (b == null) {
            b = class_2246.field_10124;
        }
        this.flowerStates[n] = b.method_9564();
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.flower_box");
    }

    public float getYaw() {
        return -this.getDirection().method_10153().method_10144();
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)ItemShelfBlock.FACING);
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (this.method_5438(index).method_7960()) {
            if (FlowerPotHandler.hasSpecialFlowerModel(stack.method_7909())) {
                return true;
            }
            if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue()) {
                return false;
            }
            return stack.method_7909() instanceof class_1747 && stack.method_31573(ModTags.FLOWER_BOX_PLANTABLE);
        }
        return false;
    }

    public class_3414 getAddItemSound() {
        return class_3417.field_17611;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return null;
    }
}

