/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Desc;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.mixinextras.injector.ModifyExpressionValue;
import virtuoel.mixinextras.injector.wrapoperation.Operation;
import virtuoel.mixinextras.injector.wrapoperation.WrapOperation;
import virtuoel.mixinextras.sugar.Local;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"})
    private void pehkui$dropItem(ItemStack stack, boolean spread, boolean thrown, CallbackInfoReturnable<ItemEntity> info) {
        ItemEntity entity = (ItemEntity)info.getReturnValue();
        if (entity != null) {
            ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
            float scale = ScaleUtils.getEyeHeightScale((Entity)this);
            if (scale != 1.0f) {
                Vector3d pos = entity.func_213303_ch();
                entity.func_70107_b(pos.field_72450_a, pos.field_72448_b + (double)(1.0f - scale) * 0.3, pos.field_72449_c);
            }
        }
    }

    @WrapOperation(method={"tickMovement()V"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;")})
    private AxisAlignedBB pehkui$tickMovement$expand(AxisAlignedBB obj, double x, double y, double z, Operation<AxisAlignedBB> original) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)this);
        if (widthScale != 1.0f) {
            x *= (double)widthScale;
            z *= (double)widthScale;
        }
        if (heightScale != 1.0f) {
            y *= (double)heightScale;
        }
        return original.call(obj, x, y, z);
    }

    @ModifyExpressionValue(method={"attack(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="CONSTANT", args={"floatValue=0.5F"}, ordinal=1), @At(value="CONSTANT", args={"floatValue=0.5F"}, ordinal=2), @At(value="CONSTANT", args={"floatValue=0.5F"}, ordinal=3)})
    private float pehkui$attack$knockback(float value) {
        float scale = ScaleUtils.getKnockbackScale((Entity)this);
        return scale != 1.0f ? scale * value : value;
    }

    @ModifyExpressionValue(method={"getAttackCooldownProgressPerTick"}, at={@At(value="CONSTANT", args={"doubleValue=20.0D"})})
    private double pehkui$getAttackCooldownProgressPerTick$multiplier(double value) {
        float scale = ScaleUtils.getAttackSpeedScale((Entity)this);
        return scale != 1.0f ? value / (double)scale : value;
    }

    @Inject(at={@At(value="RETURN")}, target={@Desc(value="getDigSpeed", args={BlockState.class, BlockPos.class}, ret=float.class)}, cancellable=true)
    private void pehkui$getBlockBreakingSpeed(BlockState block, BlockPos pos, CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getMiningSpeedScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @ModifyExpressionValue(method={"updateCapeAngles"}, at={@At(value="CONSTANT", args={"doubleValue=10.0D"}), @At(value="CONSTANT", args={"doubleValue=-10.0D"})})
    private double pehkui$updateCapeAngles$limits(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale != 1.0f ? (double)scale * value : value;
    }

    @WrapOperation(method={"attack(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;")})
    private AxisAlignedBB pehkui$attack$expand(AxisAlignedBB obj, double x, double y, double z, Operation<AxisAlignedBB> original, @Local(argsOnly=true) Entity target) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale(target);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale(target);
        if (widthScale != 1.0f) {
            x *= (double)widthScale;
            z *= (double)widthScale;
        }
        if (heightScale != 1.0f) {
            y *= (double)heightScale;
        }
        return original.call(obj, x, y, z);
    }
}

