/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;

public final class ReflectionUtils {
    public static float getFlyingSpeed(LivingEntity entity) {
        return entity.field_70747_aH;
    }

    public static void setFlyingSpeed(LivingEntity entity, float speed) {
        entity.field_70747_aH = speed;
    }

    public static double getMountedHeightOffset(Entity entity) {
        return entity.func_70042_X();
    }

    public static float getDimensionsWidth(EntitySize dimensions) {
        return dimensions.field_220315_a;
    }

    public static float getDimensionsHeight(EntitySize dimensions) {
        return dimensions.field_220316_b;
    }

    public static void setOnGround(Entity entity, boolean onGround) {
        entity.func_230245_c_(onGround);
    }

    public static void sendPacket(ServerPlayNetHandler handler, IPacket<?> packet) {
        handler.func_147359_a(packet);
    }

    public static boolean isDummy(MinMaxBounds<?> range) {
        return range.func_211335_c();
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    public static <T> Optional<Constructor<T>> getConstructor(Optional<Class<T>> clazz, Class<?> ... params) {
        return clazz.map(c -> {
            try {
                return c.getConstructor(params);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }
}

