/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.block;

import net.freedinner.display.block.AbstractItemBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.redstone.Orientation;

public abstract class AbstractStackableBlock
extends AbstractItemBlock {
    public static final IntegerProperty STACKS = IntegerProperty.create((String)"stacks", (int)1, (int)4);

    public AbstractStackableBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)STACKS, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blok, Orientation ori, boolean bool) {
        if (!world.isClientSide() && !this.canSurvive(state, (LevelReader)world, pos) && this.getStacks(state) > 1) {
            for (int i = 1; i < this.getStacks(state); ++i) {
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)this.getStackFor());
            }
        }
        super.neighborChanged(state, world, pos, blok, ori, bool);
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, boolean check, FluidState fluid) {
        if (this.getStacks(state) > 1) {
            for (int i = 1; i < this.getStacks(state); ++i) {
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)this.getStackFor());
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, stack, check, fluid);
    }

    @Override
    public void onDestroyedByPushReaction(BlockState state, Level world, BlockPos pos, Direction dir, FluidState fluid) {
        if (this.getStacks(state) > 1) {
            for (int i = 1; i < this.getStacks(state); ++i) {
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)this.getStackFor());
            }
        }
        super.onDestroyedByPushReaction(state, world, pos, dir, fluid);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STACKS});
    }

    public int getStacks(BlockState state) {
        return (Integer)state.getValue((Property)STACKS);
    }

    public BlockState getState(BlockState state) {
        return (BlockState)state.setValue((Property)STACKS, (Comparable)Integer.valueOf(this.getStacks(state) + 1));
    }

    public abstract int getMaxStackable();
}

