/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.entity;

import net.freedinner.display.init.DisplayTags;
import net.freedinner.display.util.BlockAssociations;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class AbstractDisplayEntity
extends LivingEntity {
    public long lastHit;

    public AbstractDisplayEntity(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    public InteractionResult interactAt(Player player, Vec3 v, InteractionHand hand) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                ItemStack stack = player.getItemInHand(hand);
                ItemStack current = this.getMainHandItem();
                if (current.isEmpty()) {
                    Block target = BlockAssociations.getBlockFor(stack.getItem());
                    if (stack.is(DisplayTags.DISPLAYABLE) && this.isCorrectBlock(target)) {
                        ItemStack copy = stack.copy();
                        copy.setCount(1);
                        this.setItemInHand(InteractionHand.MAIN_HAND, copy);
                        this.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)target.asItem()));
                        lvl.playSound(null, this.blockPosition(), target.defaultBlockState().getSoundType((LevelReader)this.level(), this.blockPosition(), (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                        stack.shrink(1);
                        player.swing(hand, true);
                        return InteractionResult.SUCCESS;
                    }
                } else if (player.getMainHandItem().isEmpty()) {
                    Block target = BlockAssociations.getBlockFor(current.getItem());
                    player.addItem(current);
                    current.shrink(1);
                    this.getOffhandItem().shrink(1);
                    lvl.playSound(null, this.blockPosition(), target.defaultBlockState().getSoundType((LevelReader)this.level(), this.blockPosition(), (Entity)player).getBreakSound(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                    player.swing(hand, true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean hurtServer(ServerLevel lvl, DamageSource source, float amount) {
        if (!this.isRemoved() && source.getEntity() != null) {
            if (source.isCreativePlayer() || source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || source.is(DamageTypeTags.IS_EXPLOSION)) {
                this.die(source);
            } else {
                long i = this.level().getGameTime();
                if (i - this.lastHit > 5L) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)32);
                    this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
                    this.lastHit = i;
                } else {
                    this.die(source);
                }
                return true;
            }
        }
        return false;
    }

    public void die(DamageSource source) {
        Player player;
        super.die(source);
        Entity entity = source.getEntity();
        boolean flag = entity instanceof Player && (player = (Player)entity).isCreative();
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
        this.showBreakingParticles();
        if (!flag) {
            ItemEntity target = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getPickResult());
            target.setPickUpDelay(10);
            this.level().addFreshEntity((Entity)target);
            if (!this.getMainHandItem().isEmpty()) {
                ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getMainHandItem());
                drop.setPickUpDelay(10);
                this.level().addFreshEntity((Entity)drop);
            }
        }
        this.discard();
    }

    public void handleEntityEvent(byte b) {
        if (b == 32) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(b);
        }
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void setYBodyRot(float f1) {
        this.yBodyRotO = this.yRotO = f1;
        this.yHeadRotO = this.yHeadRot = f1;
    }

    public void setYHeadRot(float f1) {
        this.yBodyRotO = this.yRotO = f1;
        this.yHeadRotO = this.yHeadRot = f1;
    }

    protected void tickHeadTurn(float f1) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity target) {
    }

    protected void pushEntities() {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public boolean isCorrectBlock(Block target) {
        return false;
    }

    private void showBreakingParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            lvl.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.35), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }
}

