/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.events;

import java.util.Optional;
import net.freedinner.display.events.DisplayManager;
import net.freedinner.display.init.DisplayBlocks;
import net.freedinner.display.init.DisplayTags;
import net.freedinner.display.util.BlockAssociations;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber
public class DisplayEvents {
    @SubscribeEvent
    public static void onCheck(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().isCrouching() && event.getItemStack().is(DisplayTags.DISPLAYABLE)) {
            DisplayManager.placeItem(event.getEntity(), event.getLevel(), event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
    }

    @SubscribeEvent
    public static void onItemCheck(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity().isCrouching() && event.getItemStack().is(DisplayTags.DISPLAYABLE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTags(TagsUpdatedEvent event) {
        Optional items = event.getLookupProvider().lookupOrThrow(Registries.ITEM).get(DisplayTags.DISPLAYABLE);
        if (items.isPresent()) {
            block0: for (Holder target : (HolderSet.Named)items.get()) {
                for (DeferredHolder block : DisplayBlocks.REGISTRY.getEntries()) {
                    if (!target.getRegisteredName().contains(block.getId().getPath()) || BlockAssociations.getItemFor((Block)block.get()) != Items.AIR) continue;
                    BlockAssociations.addToMap((Item)target.value(), (Block)block.get());
                    continue block0;
                }
            }
        }
    }
}

