/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.freedinner.display.client.model.PillowModel;
import net.freedinner.display.client.renderer.PillowedItemLayer;
import net.freedinner.display.entity.ItemPillow;
import net.freedinner.display.init.DisplayModels;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PillowRenderer
extends LivingEntityRenderer<ItemPillow, PillowModel<ItemPillow>> {
    public PillowRenderer(EntityRendererProvider.Context context) {
        super(context, new PillowModel(context.bakeLayer(DisplayModels.PILLOW)), 0.0f);
        this.addLayer(new PillowedItemLayer((RenderLayerParent<ItemPillow, PillowModel<ItemPillow>>)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(ItemPillow target) {
        return ResourceLocation.fromNamespaceAndPath((String)"items_displayed", (String)("textures/entity/jewelry_pillow/" + target.getColor() + "_jewelry_pillow.png"));
    }

    protected boolean shouldShowName(ItemPillow target) {
        return false;
    }

    protected void setupRotations(ItemPillow target, PoseStack pose, float f1, float f2, float f3, float f4) {
        pose.mulPose(Axis.YP.rotationDegrees(180.0f - f2));
        float f = (float)(target.level().getGameTime() - target.lastHit) + f3;
        if (f < 5.0f) {
            pose.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }
}

