/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyAttributes;
import doggytalents.common.backward_imitate.EntityHelper_21_3;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.misc.DogArrow;
import doggytalents.common.entity.misc.DogFoodProjectile;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.entity.misc.DoggyBeamEntity;
import doggytalents.common.entity.misc.Piano;
import doggytalents.common.entity.misc.SamoyedPlushie;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DoggyEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"doggytalents");
    public static final Supplier<EntityType<Dog>> DOG = DoggyEntityTypes.register("dog", Dog::new, MobCategory.CREATURE, b -> b.sized(0.6f, 0.85f).setUpdateInterval(3).setTrackingRange(16).setShouldReceiveVelocityUpdates(true));
    public static final Supplier<EntityType<DoggyBeamEntity>> DOG_BEAM = DoggyEntityTypes.register("dog_beam", DoggyBeamEntity::new, MobCategory.MISC, b -> b.sized(0.25f, 0.25f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).noSummon());
    public static final Supplier<EntityType<Piano>> GRAND_PIANO_BLACK = DoggyEntityTypes.register("grand_piano_black", Piano::new, MobCategory.MISC, b -> b.sized(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final Supplier<EntityType<Piano>> GRAND_PIANO_WHITE = DoggyEntityTypes.register("grand_piano_white", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.GRAND, Piano.PianoColor.WHITE), MobCategory.MISC, b -> b.sized(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final Supplier<EntityType<Piano>> UPRIGHT_PIANO_BLACK = DoggyEntityTypes.register("upright_piano_black", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.UPRIGHT, Piano.PianoColor.BLACK), MobCategory.MISC, b -> b.sized(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final Supplier<EntityType<Piano>> UPRIGHT_PIANO_BROWN = DoggyEntityTypes.register("upright_piano_brown", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.UPRIGHT, Piano.PianoColor.BROWN), MobCategory.MISC, b -> b.sized(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final Supplier<EntityType<Piano>> UPRIGHT_PIANO_WHITE = DoggyEntityTypes.register("upright_piano_white", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.UPRIGHT, Piano.PianoColor.WHITE), MobCategory.MISC, b -> b.sized(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final Supplier<EntityType<DogPlushie>> DOG_PLUSHIE_TOY = DoggyEntityTypes.register("dog_plushie_toy", (type, level) -> new DogPlushie(type, level), MobCategory.MISC, b -> b.sized(0.5f, 0.5f).setUpdateInterval(3).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final Supplier<EntityType<SamoyedPlushie>> SAMOYED_PLUSHIE_TOY = DoggyEntityTypes.register("samoyed_plushie_toy", (type, level) -> new SamoyedPlushie(type, level), MobCategory.MISC, b -> b.sized(0.5f, 0.5f).setUpdateInterval(3).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final Supplier<EntityType<DogFoodProjectile>> DOG_FOOD_PROJ = DoggyEntityTypes.register("dog_food_projectile", DogFoodProjectile::new, MobCategory.MISC, b -> b.sized(0.25f, 0.25f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).noSummon());
    public static final Supplier<EntityType<DogGunpowderProjectile>> DOG_GUNPOWDER_PROJ = DoggyEntityTypes.register("dog_gunpowder_projectile", DogGunpowderProjectile::new, MobCategory.MISC, b -> b.sized(0.25f, 0.25f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).noSummon());
    public static final Supplier<EntityType<DogThrownTrident>> DOG_TRIDENT_PROJ = DoggyEntityTypes.register("dog_trident_proj", DogThrownTrident::new, MobCategory.MISC, b -> b.sized(0.5f, 0.5f).eyeHeight(0.13f).setTrackingRange(4).updateInterval(20).setShouldReceiveVelocityUpdates(true).noSummon());
    public static final Supplier<EntityType<DogArrow>> DOG_ARROW_PROJ = DoggyEntityTypes.register("dog_arrow_proj", DogArrow::new, MobCategory.MISC, b -> b.sized(0.5f, 0.5f).eyeHeight(0.13f).setTrackingRange(4).updateInterval(20).setShouldReceiveVelocityUpdates(true).noSummon());

    private static <E extends Entity, T extends EntityType<E>> Supplier<EntityType<E>> register(String name, EntityType.EntityFactory<E> sup, MobCategory classification, Function<EntityType.Builder<E>, EntityType.Builder<E>> builder) {
        return DoggyEntityTypes.register(name, () -> ((EntityType.Builder)builder.apply(EntityType.Builder.of((EntityType.EntityFactory)sup, (MobCategory)classification))).build(EntityHelper_21_3.entityKey(name)));
    }

    private static <E extends Entity, T extends EntityType<E>> Supplier<T> register(String name, Supplier<T> sup) {
        return ENTITIES.register(name, sup);
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent e) {
        e.put(DOG.get(), Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.ATTACK_DAMAGE, 2.0).add(DoggyAttributes.JUMP_POWER, 0.42).add(DoggyAttributes.CRIT_CHANCE, 0.01).add(DoggyAttributes.CRIT_BONUS, 1.0).add(Attributes.FLYING_SPEED, 0.3).build());
    }
}

