/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import com.mojang.brigadier.CommandDispatcher;
import doggytalents.DogVariants;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyBrewingRecipes;
import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyEffects;
import doggytalents.DoggyEntitySubPredicates;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItemGroups;
import doggytalents.DoggyItems;
import doggytalents.DoggyRecipeSerializers;
import doggytalents.DoggyRegistries;
import doggytalents.DoggySerializers;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.TalentsOptions;
import doggytalents.api.feature.FoodHandler;
import doggytalents.client.ClientSetup;
import doggytalents.client.DTNClientDogSleepOnManager;
import doggytalents.client.DTNClientPettingManager;
import doggytalents.client.DoggyKeybinds;
import doggytalents.client.backward_imitate.DTNModelProvider_1_21_5;
import doggytalents.client.entity.render.world.BedFinderRenderer;
import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.backward_imitate.DTNRecipeProvider_21_3;
import doggytalents.common.backward_imitate.EventRegister_1_21_5;
import doggytalents.common.backward_imitate.EventRegister_1_21_7;
import doggytalents.common.backward_imitate.EventRegister_21_3;
import doggytalents.common.backward_imitate.TicketTypeUtil_1_21_5;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import doggytalents.common.command.DoggyCommands;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.data.DTAdvancementProvider;
import doggytalents.common.data.DTBlockTagsProvider;
import doggytalents.common.data.DTEntityTagsProvider;
import doggytalents.common.data.DTItemTagsProvider;
import doggytalents.common.data.DTLootModifierProvider;
import doggytalents.common.data.DTLootTableProvider;
import doggytalents.common.data.DTNDataRegistryProvider;
import doggytalents.common.data.DTNDatapackProvider;
import doggytalents.common.data.DTNPackMetadataProvider;
import doggytalents.common.data.neoforge_data.DTNNeoForgeDataEntry;
import doggytalents.common.entity.BoostingFoodHandler;
import doggytalents.common.entity.DogDrinkMilkHandler;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.entity.WhitelistFoodHandler;
import doggytalents.common.event.EventHandler;
import doggytalents.common.event.PackHandler;
import doggytalents.common.item.ChopinRecordItem;
import doggytalents.common.item.itemgroup.DTNCompostables;
import doggytalents.common.item.itemgroup.DTNItemCategory;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.PacketHandler;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="doggytalents")
public class DoggyTalentsNext {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents");

    public DoggyTalentsNext() {
        IEventBus modEventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        DogVariants.DOG_VARIANT.register(modEventBus);
        DogVariants.DOG_VARIANT_VANILLA.register(modEventBus);
        DoggyBlocks.BLOCKS.register(modEventBus);
        DoggyTileEntityTypes.TILE_ENTITIES.register(modEventBus);
        DoggyItems.ITEMS.register(modEventBus);
        DoggyEntityTypes.ENTITIES.register(modEventBus);
        DoggyContainerTypes.CONTAINERS.register(modEventBus);
        DoggySerializers.SERIALIZERS.register(modEventBus);
        TalentsOptions.TALENT_OPTIONS.register(modEventBus);
        DoggySounds.SOUNDS.register(modEventBus);
        DoggyRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        DoggyTalents.TALENTS.register(modEventBus);
        DoggyAccessories.ACCESSORIES.register(modEventBus);
        DoggyAccessoryTypes.ACCESSORY_TYPES.register(modEventBus);
        DoggyAttributes.ATTRIBUTES.register(modEventBus);
        DoggyItemGroups.ITEM_GROUP.register(modEventBus);
        DoggyEffects.EFFECTS.register(modEventBus);
        DoggyAdvancementTriggers.TRIGGERS.register(modEventBus);
        DoggyEntitySubPredicates.ENTITY_SUB_PREDICATES.register(modEventBus);
        DTLootModifierProvider.CODEC.register(modEventBus);
        modEventBus.addListener(DoggyRegistries::newRegistry);
        modEventBus.addListener(DoggyEntityTypes::addEntityAttributes);
        modEventBus.addListener(DTNNetworkHandler::onRegisterPayloadEvent);
        modEventBus.addListener(ClientSetup::setupScreenManagers);
        modEventBus.addListener(PackHandler::onAddPackFinder);
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        forgeEventBus.addListener(this::serverStarting);
        forgeEventBus.addListener(this::registerCommands);
        forgeEventBus.addListener(DoggyBrewingRecipes::onRegisterEvent);
        forgeEventBus.addListener(ChopinRecordItem::onRightClickBlock);
        forgeEventBus.register((Object)new EventHandler());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(DoggyKeybinds::registerDTKeyMapping);
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(DoggyBlocks::registerBlockColours);
            modEventBus.addListener(ClientEventHandler::modifyBakedModels);
            modEventBus.addListener(ClientSetup::setupTileEntityRenderers);
            modEventBus.addListener(ClientSetup::setupEntityRenderers);
            modEventBus.addListener(ClientSetup::addClientReloadListeners);
            modEventBus.addListener(ClientSetup::registerOverlay);
            forgeEventBus.register((Object)new ClientEventHandler());
            forgeEventBus.addListener(BedFinderRenderer::onWorldRenderLast);
            forgeEventBus.addListener(CanineTrackerLocateRenderer::onWorldRenderLast);
            forgeEventBus.addListener(CanineTrackerLocateRenderer::tickUpdate);
            forgeEventBus.register((Object)DTNClientPettingManager.get());
            forgeEventBus.register((Object)DTNClientDogSleepOnManager.get());
        }
        ConfigHandler.init(modEventBus);
        EventRegister_21_3.registerEvent(modEventBus, forgeEventBus);
        EventRegister_1_21_5.registerEvent(modEventBus, forgeEventBus);
        TicketTypeUtil_1_21_5.init(modEventBus);
        EventRegister_1_21_7.registerEvent(modEventBus, forgeEventBus);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        DTNNetworkHandler.init();
        PacketHandler.init();
        FoodHandler.registerHandler(new MeatFoodHandler());
        FoodHandler.registerHandler(new BoostingFoodHandler());
        FoodHandler.registerHandler(new DogDrinkMilkHandler());
        FoodHandler.registerHandler(new WhitelistFoodHandler());
        event.enqueueWork(() -> {
            ConfigHandler.initTalentConfig();
            RiceMillBlockEntity.initGrindMap();
            DTNItemCategory.init();
            DTNCompostables.init();
        });
    }

    public void serverStarting(ServerStartingEvent event) {
    }

    public void registerCommands(RegisterCommandsEvent event) {
        DoggyCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientSetup.onClientSetup(event);
    }

    private void gatherData(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        DTNPackMetadataProvider.start((GatherDataEvent)event);
        gen.addProvider(true, (DataProvider)new DTNModelProvider_1_21_5(packOutput));
        gen.addProvider(true, (DataProvider)new DTAdvancementProvider(packOutput, lookup));
        DTBlockTagsProvider blockTagProvider = new DTBlockTagsProvider(packOutput, lookup);
        gen.addProvider(true, (DataProvider)blockTagProvider);
        gen.addProvider(true, (DataProvider)new DTItemTagsProvider(packOutput, lookup));
        gen.addProvider(true, (DataProvider)new DTNRecipeProvider_21_3(packOutput, lookup));
        gen.addProvider(true, (DataProvider)new DTLootTableProvider(packOutput, lookup));
        gen.addProvider(true, (DataProvider)new DTLootModifierProvider(packOutput, lookup));
        gen.addProvider(true, (DataProvider)new DTEntityTagsProvider(packOutput, lookup));
        DTNDatapackProvider.start((GatherDataEvent)event);
        DTNDataRegistryProvider.start((GatherDataEvent)event);
        DTNNeoForgeDataEntry.onGatherData((GatherDataEvent)event);
    }
}

