/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.ElytraCapeModel;
import doggytalents.common.entity.Dog;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class FieryReflectorModel
extends ElytraCapeModel {
    public ModelPart reflector;
    public ModelPart divineCape;
    private boolean incapacitated;

    public FieryReflectorModel(ModelPart root) {
        super(root);
    }

    @Override
    protected void populatePart(ModelPart box) {
        super.populatePart(box);
        this.reflector = this.elytra.getChild("disc");
        this.divineCape = this.elytra.getChild("divine_cape");
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(dogIn, limbSwing, limbSwingAmount, partialTickTime);
        this.incapacitated = !dogIn.isDoingFine();
        this.lWing.visible = !this.incapacitated;
        this.rWing.visible = !this.incapacitated;
        this.divineCape.visible = !this.incapacitated;
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.reflector.yRot = 6.0f * ageInTicks % 360.0f * ((float)Math.PI / 180);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition upper_body = partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.addOrReplaceChild("elytra_rot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.addOrReplaceChild("elytra", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition divine_cape = elytra.addOrReplaceChild("divine_cape", CubeListBuilder.create().texOffs(30, 42).mirror().addBox(-5.8914f, 3.8079f, 2.3224f, 15.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-1.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition disc = elytra.addOrReplaceChild("disc", CubeListBuilder.create().texOffs(24, 29).addBox(-5.0f, -0.35f, -5.15f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-5.0f, -0.35f, -5.15f, 10.0f, 1.0f, 10.0f, new CubeDeformation(-0.099f)).texOffs(28, 33).addBox(-3.0f, -0.55f, -3.15f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.1f)).texOffs(32, 37).addBox(-1.0f, -1.6f, -1.15f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)-5.9f, (float)7.4f));
        PartDefinition cube_r1 = disc.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 33).addBox(-3.0f, -0.5f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.05f, (float)-0.15f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition right_wing = elytra.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_r1 = right_wing.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(0, 42).addBox(-6.6851f, 3.7889f, 2.3232f, 12.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)-0.1309f, (float)0.0f));
        PartDefinition left_wing = elytra.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_r1 = left_wing.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(-4.8914f, 3.8079f, 2.3224f, 12.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        super.renderToBuffer(stack, p_103014_, this.incapacitated ? p_103015_ : 0xF000F0, p_103016_, color_overlay);
    }
}

