/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.backward_imitate.BaseDogModel_21_3;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class SyncedAccessoryModel
extends BaseDogModel_21_3 {
    public final ModelPart root;
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
    public Optional<ModelPart> head = Optional.empty();
    public Optional<ModelPart> realHead = Optional.empty();
    public Optional<ModelPart> body = Optional.empty();
    public Optional<ModelPart> mane = Optional.empty();
    public Optional<ModelPart> legBackRight = Optional.empty();
    public Optional<ModelPart> legBackLeft = Optional.empty();
    public Optional<ModelPart> legFrontRight = Optional.empty();
    public Optional<ModelPart> legFrontLeft = Optional.empty();
    public Optional<ModelPart> tail = Optional.empty();
    public Optional<ModelPart> realTail = Optional.empty();

    public SyncedAccessoryModel(ModelPart root) {
        this.root = root;
        this.populatePart(root);
    }

    protected abstract void populatePart(ModelPart var1);

    public void sync(DogModel dogModel) {
        this.syncPart(this.root, dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.syncPart(this.body, dogModel.body);
        this.syncPart(this.mane, dogModel.mane);
        this.syncPart(this.legBackRight, dogModel.legBackRight);
        this.syncPart(this.legBackLeft, dogModel.legBackLeft);
        this.syncPart(this.legFrontRight, dogModel.legFrontRight);
        this.syncPart(this.legFrontLeft, dogModel.legFrontLeft);
        this.syncPart(this.tail, dogModel.tail);
        this.syncPart(this.realTail, dogModel.realTail);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<ModelPart> part, ModelPart dogPart) {
        part.ifPresent(p -> this.syncPart((ModelPart)p, dogPart));
    }

    private void syncPart(ModelPart part, ModelPart dogPart) {
        part.copyFrom(dogPart);
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        stack.pushPose();
        stack.translate((double)(this.root.x / 16.0f), (double)(this.root.y / 16.0f), (double)(this.root.z / 16.0f));
        stack.translate((double)(this.pivot.x / 16.0f), (double)(this.pivot.y / 16.0f), (double)(this.pivot.z / 16.0f));
        if (this.root.zRot != 0.0f) {
            stack.mulPose((Quaternionfc)Axis.ZP.rotation(this.root.zRot));
        }
        if (this.root.yRot != 0.0f) {
            stack.mulPose((Quaternionfc)Axis.YP.rotation(this.root.yRot));
        }
        if (this.root.xRot != 0.0f) {
            stack.mulPose((Quaternionfc)Axis.XP.rotation(this.root.xRot));
        }
        float xRot0 = this.root.xRot;
        float yRot0 = this.root.yRot;
        float zRot0 = this.root.zRot;
        float x0 = this.root.x;
        float y0 = this.root.y;
        float z0 = this.root.z;
        this.root.xRot = 0.0f;
        this.root.yRot = 0.0f;
        this.root.zRot = 0.0f;
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.z = 0.0f;
        stack.pushPose();
        stack.translate((double)(-this.pivot.x / 16.0f), (double)(-this.pivot.y / 16.0f), (double)(-this.pivot.z / 16.0f));
        if (this.young) {
            boolean headSync = this.head.isPresent();
            boolean headVisible0 = false;
            if (headSync) {
                headVisible0 = this.head.get().visible;
                this.head.get().visible = false;
            }
            stack.pushPose();
            this.root.render(stack, p_103014_, p_103015_, p_103016_, color_overlay);
            stack.popPose();
            if (headSync) {
                this.head.get().visible = headVisible0;
                stack.pushPose();
                stack.scale(2.0f, 2.0f, 2.0f);
                stack.translate(0.0, -0.5, 0.15);
                this.head.get().render(stack, p_103014_, p_103015_, p_103016_, color_overlay);
                stack.popPose();
            }
        } else {
            this.root.render(stack, p_103014_, p_103015_, p_103016_, color_overlay);
        }
        stack.popPose();
        stack.popPose();
        this.root.xRot = xRot0;
        this.root.yRot = yRot0;
        this.root.zRot = zRot0;
        this.root.x = x0;
        this.root.y = y0;
        this.root.z = z0;
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
    }

    @Override
    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

