/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.SmallButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.accessory.LocatorOrbAccessory;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.slot.DogInventorySlot;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogInventoryPageData;
import doggytalents.common.util.Util;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DogInventoriesScreen
extends AbstractContainerScreen<DogInventoriesContainer> {
    private Button left;
    private Button right;
    private Player player;

    public DogInventoriesScreen(DogInventoriesContainer packPuppy, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)packPuppy, playerInventory, displayName);
        this.player = playerInventory.player;
    }

    public void init() {
        super.init();
        this.left = new SmallButton(this.leftPos + this.imageWidth - 29, this.topPos + 4, (Component)Component.literal((String)"<"), btn -> {
            int page = ((DogInventoriesContainer)this.getMenu()).getViewOffset();
            if (page > 0) {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogInventoryPageData(--page));
            }
            btn.active = page > 0;
            this.right.active = page < ((DogInventoriesContainer)this.getMenu()).getTotalNumColumns() - 9;
        });
        this.right = new SmallButton(this.leftPos + this.imageWidth - 26 + 9, this.topPos + 4, (Component)Component.literal((String)">"), btn -> {
            int page = ((DogInventoriesContainer)this.getMenu()).getViewOffset();
            if (page < ((DogInventoriesContainer)this.getMenu()).getTotalNumColumns() - 9) {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogInventoryPageData(++page));
            }
            btn.active = page < ((DogInventoriesContainer)this.getMenu()).getTotalNumColumns() - 9;
            this.left.active = page > 0;
        });
        if (((DogInventoriesContainer)this.getMenu()).getTotalNumColumns() > 9) {
            this.left.active = false;
            this.right.active = true;
        } else {
            this.left.visible = false;
            this.right.visible = false;
        }
        this.addRenderableWidget((GuiEventListener)this.left);
        this.addRenderableWidget((GuiEventListener)this.right);
    }

    protected void renderLabels(GuiGraphics graphics, int par1, int par2) {
        graphics.drawString(this.font, this.title.getString(), 8, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int xMouse, int yMouse) {
        int l = (this.width - this.imageWidth) / 2;
        int i1 = (this.height - this.imageHeight) / 2;
        ScreenUtil.blit_21_3(graphics, Resources.DOG_INVENTORY, l, i1, 0, 0, this.imageWidth, this.imageHeight);
        for (DogInventorySlot slot : ((DogInventoriesContainer)this.getMenu()).getSlots()) {
            if (!slot.isActive()) continue;
            float[] slot_color = this.getSlotShaderColor(slot.getDog());
            float[] color_arr_1_21_7 = new float[]{slot_color[0], slot_color[1], slot_color[2], 1.0f};
            ScreenUtil.blitColored_1_21_7(graphics, Resources.DOG_INVENTORY, l + slot.x - 1, i1 + slot.y - 1, 197.0f, 2.0f, 18, 18, color_arr_1_21_7);
        }
    }

    public float[] getSlotShaderColor(Dog dog) {
        Object object;
        if (dog == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        Optional<AccessoryInstance> inst = dog.getAccessory(DoggyAccessoryTypes.SCARF.get());
        if (inst.isPresent() && (object = inst.get().getAccessory()) instanceof LocatorOrbAccessory) {
            LocatorOrbAccessory orb = (LocatorOrbAccessory)object;
            return Util.rgbIntToFloatArray(orb.getOrbColor());
        }
        inst = dog.getAccessory(DoggyAccessoryTypes.COLLAR.get());
        if (inst.isPresent() && (object = inst.get()) instanceof DyeableAccessory.DyeableAccessoryInstance) {
            DyeableAccessory.DyeableAccessoryInstance dyable_inst = (DyeableAccessory.DyeableAccessoryInstance)object;
            return dyable_inst.getColor();
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            if (this.player.getAbilities().instabuild) {
                this.minecraft.setScreen((Screen)new CreativeModeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), ((Boolean)this.minecraft.options.operatorItemsTab().get()).booleanValue()));
            } else {
                this.minecraft.setScreen((Screen)new InventoryScreen(this.player));
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((DogInventoriesContainer)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            graphics.renderItem(this.hoveredSlot.getItem(), mouseX, mouseY);
        }
    }
}

