/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.backward_imitate;

import com.mojang.serialization.DynamicOps;
import doggytalents.DogSounds;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.LangUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class EntityUtil_1_21_5 {
    @Nullable
    public static UUID getOwnerUUID(TamableAnimal entity) {
        EntityReference ref = entity.getOwnerReference();
        if (ref == null) {
            return null;
        }
        return ref.getUUID();
    }

    public static List<ItemStack> getArmorSlots(LivingEntity entity) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(4);
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = entity.getItemBySlot(slot)).isEmpty()) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static List<ItemStack> getHandSlot(LivingEntity entity) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlotGroup.HAND) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HAND || (stack = entity.getItemBySlot(slot)).isEmpty()) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static CompoundTag tryEncodeEffect(MobEffectInstance ins) {
        try {
            Optional result = MobEffectInstance.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)ins).result();
            if (!result.isPresent()) {
                return new CompoundTag();
            }
            Object t = result.get();
            if (!(t instanceof CompoundTag)) {
                return new CompoundTag();
            }
            CompoundTag effect_tag = (CompoundTag)t;
            return effect_tag;
        }
        catch (Exception exception) {
            return new CompoundTag();
        }
    }

    public static SoundEvent legacyWolfGrowlSound(Dog dog) {
        return LangUtil.getRandomItem(dog.getRandom(), List.of(DogSounds.CLASSIC_GROWL1.get(), DogSounds.CLASSIC_GROWL2.get(), DogSounds.CLASSIC_GROWL3.get())).get();
    }

    public static SoundEvent legacyWolfAmbientSound(Dog dog) {
        return LangUtil.getRandomItem(dog.getRandom(), List.of(DogSounds.CLASSIC_BARK1.get(), DogSounds.CLASSIC_BARK2.get(), DogSounds.CLASSIC_BARK3.get())).get();
    }

    public static SoundEvent legacyWolfHurtSound(Dog dog) {
        return LangUtil.getRandomItem(dog.getRandom(), List.of(DogSounds.CLASSIC_HURT1.get(), DogSounds.CLASSIC_HURT2.get(), DogSounds.CLASSIC_HURT3.get())).get();
    }

    public static SoundEvent legacyWolfHowlSound(Dog dog) {
        return LangUtil.getRandomItem(dog.getRandom(), List.of(DogSounds.CLASSIC_HOWL1.get(), DogSounds.CLASSIC_HOWL2.get())).get();
    }

    public static void spawnProjectile(AbstractDog dog, Projectile proj) {
        ItemStack proj_stack = ItemStack.EMPTY;
        if (proj instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)proj;
            proj_stack = arrow.getPickupItemStackOrigin();
        }
        if (proj_stack.isEmpty()) {
            dog.level().addFreshEntity((Entity)proj);
        } else {
            Projectile.spawnProjectile((Projectile)proj, (ServerLevel)((ServerLevel)dog.level()), (ItemStack)proj_stack);
        }
    }
}

