/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.phys.Vec3;

public class DogMoveBackToRestrictGoal
extends MoveTowardsRestrictionGoal {
    private Dog dog;
    private int tickTillAttemptTp;

    public DogMoveBackToRestrictGoal(Dog dog) {
        super((PathfinderMob)dog, 1.0);
        this.dog = dog;
    }

    public boolean canUse() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.getMode().canWander()) {
            return false;
        }
        return super.canUse();
    }

    public void start() {
        super.start();
        this.tickTillAttemptTp = 2;
    }

    public void tick() {
        if (this.teleportBackIfNeeded()) {
            return;
        }
        super.tick();
    }

    public void stop() {
        super.stop();
        this.dog.getNavigation().stop();
    }

    private boolean teleportBackIfNeeded() {
        if (!this.dog.hasDogRestriction()) {
            return false;
        }
        BlockPos center = this.dog.getDogRestrictCenter();
        if (center == null) {
            return false;
        }
        if (this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)center)) < 400.0) {
            return false;
        }
        if (--this.tickTillAttemptTp > 0) {
            return false;
        }
        this.tickTillAttemptTp = 10;
        if (!this.dog.level().hasChunkAt(center)) {
            return false;
        }
        return DogUtil.guessAndTryToTeleportToBlockPos(this.dog, center, Mth.floor((float)this.dog.getDogRestrictRadius()));
    }
}

