/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DogPathNavigation
extends PathNavigation
implements IDogNavLock {
    private Dog dog;
    private boolean locked;
    private boolean moveInTargetNode = false;

    public DogPathNavigation(Dog dog, Level level) {
        super((Mob)dog, level);
        this.dog = dog;
    }

    public void tick() {
        super.tick();
        if (this.isDone() && this.path != null && this.path.isDone()) {
            this.stop();
        }
        this.setSneakIfNextNodesHasDanger();
    }

    protected void followThePath() {
        boolean isCloseEnough;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        Vec3 currentPos = this.getTempMobPos();
        this.maxDistanceToWaypoint = 0.45f;
        BlockPos nextPos = this.path.getNextNodePos();
        double dx = Math.abs(this.mob.getX() - ((double)nextPos.getX() + 0.5));
        double dy = Math.abs(this.mob.getY() - (double)nextPos.getY());
        double dz = Math.abs(this.mob.getZ() - ((double)nextPos.getZ() + 0.5));
        boolean bl = isCloseEnough = dx <= (double)this.maxDistanceToWaypoint && dy < 1.0 && dz <= (double)this.maxDistanceToWaypoint;
        if (isCloseEnough) {
            this.path.advance();
            this.checkDogAndMoveInTargetNodeWhenReach();
        }
        this.doStuckDetection(currentPos);
        this.dogCheckIfMissedFirstNodeAndMaybeSkip();
    }

    private void dogCheckIfMissedFirstNodeAndMaybeSkip() {
        boolean kinda_far_from_first_node;
        boolean missed_first_node;
        if (this.isDone()) {
            return;
        }
        Path path = this.getPath();
        if (path == null || path.getNodeCount() < 2) {
            return;
        }
        boolean bl = missed_first_node = path.getNextNodeIndex() == 0;
        if (!missed_first_node) {
            return;
        }
        Node first_node = path.getNode(0);
        Node second_node = path.getNode(1);
        if (second_node.type != PathType.WALKABLE) {
            return;
        }
        double min_bb_clip = 0.1;
        double max_dist_from_first_node = 0.5 + (double)(this.dog.getBbWidth() / 2.0f) - 0.1;
        double dog_dist_from_first_node_sqr = this.dog.distanceToSqr(new Vec3((double)first_node.x + 0.5, this.dog.getY(), (double)first_node.z + 0.5));
        boolean bl2 = kinda_far_from_first_node = dog_dist_from_first_node_sqr > max_dist_from_first_node * max_dist_from_first_node;
        if (kinda_far_from_first_node) {
            return;
        }
        BlockPos bpos = this.dog.blockPosition();
        int y_diff = second_node.y - bpos.getY();
        if (y_diff > 0 || y_diff < -1) {
            return;
        }
        Vec3 pos = this.dog.position();
        Vec3 second_node_pos = Vec3.atBottomCenterOf((Vec3i)second_node.asBlockPos());
        Vec3 dist_vec = pos.subtract(second_node_pos);
        double len_xz_sqr = dist_vec.x * dist_vec.x + dist_vec.z * dist_vec.z;
        if (len_xz_sqr > 2.0) {
            return;
        }
        path.advance();
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        boolean is_first_fence_node;
        Path path = this.path;
        if (path == null) {
            return true;
        }
        BlockPos nextPos = path.getNextNodePos();
        double dy = this.dog.getY() - (double)nextPos.getY();
        if (dy < -1.75) {
            this.stop();
            return true;
        }
        Node nextNode = path.getNextNode();
        boolean bl = is_first_fence_node = nextNode.type == PathType.FENCE && path.getNextNodeIndex() == 0;
        if (!is_first_fence_node && this.dog.getPathfindingMalus(nextNode.type) < 0.0f) {
            this.stop();
            return true;
        }
        return false;
    }

    private void checkDogAndMoveInTargetNodeWhenReach() {
        if (!this.moveInTargetNode) {
            return;
        }
        Path path = this.path;
        if (path == null) {
            return;
        }
        if (!path.isDone() || path.getNodeCount() <= 0 || !path.canReach()) {
            return;
        }
        BlockPos target = path.getTarget();
        Node end_node = path.getEndNode();
        if (target == null || end_node == null) {
            return;
        }
        if (end_node.asBlockPos().equals((Object)target)) {
            return;
        }
        PathType type = WalkNodeEvaluator.getPathTypeStatic((Mob)this.dog, (BlockPos)target);
        if (this.dog.getPathfindingMalus(type) < 0.0f) {
            return;
        }
        Node node = new Node(target.getX(), target.getY(), target.getZ());
        node.type = type;
        this.path = new Path(List.of(node), target, true);
    }

    private void setSneakIfNextNodesHasDanger() {
        Optional<Pair<Integer, Node>> result_optional = this.getNodesUntilDogApproachDanger();
        if (!result_optional.isPresent()) {
            return;
        }
        if (this.dog.isInLiquid()) {
            return;
        }
        Pair<Integer, Node> result = result_optional.get();
        int danger = (Integer)result.getLeft();
        float speed_cap = danger > 1 ? 0.4f : (danger == 1 ? 0.3f : 0.2f);
        this.dog.getDefaultMoveControl().forceSneak(speed_cap);
    }

    public Optional<Pair<Integer, Node>> getNodesUntilDogApproachDanger() {
        if (this.isDone()) {
            return Optional.empty();
        }
        Path path = this.getPath();
        if (path == null) {
            return Optional.empty();
        }
        if (path.getNextNodeIndex() >= path.getNodeCount()) {
            return Optional.empty();
        }
        Pair ret = null;
        int start = path.getNextNodeIndex();
        int end = Math.min(start + 2, path.getNodeCount() - 1);
        int prev_node_y = this.dog.blockPosition().getY();
        for (int i = start; i <= end; ++i) {
            Node node = path.getNode(i);
            if (prev_node_y == node.y && i < end) continue;
            prev_node_y = node.y;
            PathType type = node.type;
            if (type == null || !DogUtil.isDangerPathType(type = this.dog.inferType(type, InferTypeContext.getDefault()))) continue;
            int danger = i - start;
            ret = danger >= 0 ? Pair.of((Object)danger, (Object)node) : null;
            break;
        }
        return Optional.ofNullable(ret);
    }

    public Optional<Node> getDogNextNode() {
        if (this.isDone()) {
            return Optional.empty();
        }
        Path path = this.getPath();
        if (path == null) {
            return Optional.empty();
        }
        int next_indx = path.getNextNodeIndex();
        if (next_indx >= path.getNodeCount()) {
            return Optional.empty();
        }
        return Optional.of(path.getNode(next_indx));
    }

    public boolean shouldDogBlockFluidPush() {
        if (this.dog.onGround()) {
            return false;
        }
        return this.getDogNextNode().isPresent();
    }

    public void setDogMoveInTargetNode() {
        this.moveInTargetNode = true;
    }

    protected boolean canUpdatePath() {
        boolean ground_canUpdatePath = this.mob.onGround() || this.mob.isInLiquid();
        return ground_canUpdatePath && !this.dog.isOnSwitchNavCooldown() && !this.locked;
    }

    public void recomputePath() {
        boolean prevLock = this.locked;
        this.locked = false;
        super.recomputePath();
        this.locked = prevLock;
    }

    public boolean moveTo(@Nullable Path p_26537_, double p_26538_) {
        this.moveInTargetNode = false;
        return super.moveTo(p_26537_, p_26538_);
    }

    public boolean isStableDestination(BlockPos pos) {
        if (this.dog.fireImmune() && this.level.getFluidState(pos).is(FluidTags.LAVA)) {
            return true;
        }
        return super.isStableDestination(pos);
    }

    protected PathFinder createPathFinder(int p_26453_) {
        this.nodeEvaluator = new DogNodeEvaluator(this::getDog);
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, p_26453_);
    }

    private Dog getDog() {
        return this.dog;
    }

    protected Vec3 getTempMobPos() {
        return DogPathNavigation.getTempDogPos(this.dog, this);
    }

    public static Vec3 getTempDogPos(Dog dog) {
        return DogPathNavigation.getTempDogPos(dog, dog.getNavigation());
    }

    public static Vec3 getTempDogPos(Dog dog, PathNavigation nav) {
        return new Vec3(dog.getX(), (double)DogPathNavigation.getSurfaceY(dog, nav), dog.getZ());
    }

    private static int getSurfaceY(Dog dog, PathNavigation nav) {
        boolean do_float_y;
        boolean bl = do_float_y = dog.isInLiquid() && nav.canFloat();
        if (!do_float_y) {
            return DogUtil.getSurfaceStandingInY(dog);
        }
        int y_block = dog.getBlockY();
        for (int y_offset = 0; y_offset <= 16; ++y_offset) {
            int check_y = y_block + y_offset;
            BlockPos check_pos = BlockPos.containing((double)dog.getX(), (double)check_y, (double)dog.getZ());
            BlockState check_state = dog.level().getBlockState(check_pos);
            if (!check_state.getFluidState().isEmpty()) continue;
            return check_y;
        }
        return y_block;
    }

    @Override
    public void lockDogNavigation() {
        this.locked = true;
    }

    @Override
    public void unlockDogNavigation() {
        this.locked = false;
    }

    @Nullable
    protected Path createPath(@Nonnull Set<BlockPos> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.createPath(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }

    public boolean canNavigateGround() {
        return true;
    }
}

