/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class Piano
extends Entity {
    private static final EntityDataAccessor<Integer> PIANO_FLAGS = SynchedEntityData.defineId(Piano.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final PianoType pianoType;
    private final PianoColor pianoColor;

    public Piano(EntityType<Piano> type, Level level) {
        super(type, level);
        this.pianoType = PianoType.GRAND;
        this.pianoColor = PianoColor.BLACK;
    }

    public Piano(EntityType<Piano> type, Level level, PianoType pianoType, PianoColor pianoColor) {
        super(type, level);
        this.pianoType = pianoType;
        this.pianoColor = pianoColor;
        this.setYRot(0.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PIANO_FLAGS, (Object)0);
    }

    protected void readAdditionalSaveData(ValueInput compound) {
        boolean bigLidClosed = CompoundTag_1_21_5.wrap(compound).getBoolean("pianoFallboardClosed");
        this.setFallboardClosed(bigLidClosed);
    }

    protected void addAdditionalSaveData(ValueOutput compound) {
        compound.putBoolean("pianoFallboardClosed", this.isFallboardClosed());
    }

    private boolean getPianoFlag(int bit) {
        return ((Integer)this.entityData.get(PIANO_FLAGS) & bit) != 0;
    }

    private void setPianoFlag(int bits, boolean flag) {
        int c = (Integer)this.entityData.get(PIANO_FLAGS);
        this.entityData.set(PIANO_FLAGS, (Object)(flag ? c | bits : c & ~bits));
    }

    public boolean isFallboardClosed() {
        return this.getPianoFlag(1);
    }

    public void setFallboardClosed(boolean val) {
        this.setPianoFlag(1, val);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isRemoved()) {
            return true;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        return !(source.getDirectEntity() instanceof Player);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isEffectiveAi() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurtServer(ServerLevel level, DamageSource source, float damage) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        killer = source.getDirectEntity();
        if (!(killer instanceof Player)) ** GOTO lbl-1000
        player = (Player)killer;
        if (player.getAbilities().instabuild) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        killedByCreative = v0;
        drop = this.getPianoDrop();
        if (!drop.isEmpty() && !killedByCreative) {
            this.spawnAtLocation(level, drop);
        }
        this.discard();
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item == Items.TORCH) {
            if (!this.level().isClientSide && player.isShiftKeyDown()) {
                this.setYRot(this.getYRot() + 45.0f);
            }
            return InteractionResult.SUCCESS;
        }
        this.setFallboardClosed(!this.isFallboardClosed());
        return InteractionResult.SUCCESS;
    }

    public ItemStack getPianoDrop() {
        EntityType type = this.getType();
        Item item = null;
        if (type == DoggyEntityTypes.GRAND_PIANO_BLACK.get()) {
            item = DoggyItems.GRAND_PIANO_BLACK.get();
        } else if (type == DoggyEntityTypes.GRAND_PIANO_WHITE.get()) {
            item = DoggyItems.GRAND_PIANO_WHITE.get();
        } else if (type == DoggyEntityTypes.UPRIGHT_PIANO_BLACK.get()) {
            item = DoggyItems.UPRIGHT_PIANO_BLACK.get();
        } else if (type == DoggyEntityTypes.UPRIGHT_PIANO_BROWN.get()) {
            item = DoggyItems.UPRIGHT_PIANO_BROWN.get();
        } else if (type == DoggyEntityTypes.UPRIGHT_PIANO_WHITE.get()) {
            item = DoggyItems.UPRIGHT_PIANO_WHITE.get();
        }
        if (item == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)item);
    }

    public PianoType getPianoType() {
        return this.pianoType;
    }

    public PianoColor getPianoColor() {
        return this.pianoColor;
    }

    public static enum PianoType {
        GRAND,
        UPRIGHT;

    }

    public static enum PianoColor {
        BLACK,
        WHITE,
        BROWN;

    }
}

