/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.common.entity.serializers.Dimension2BlockPosMap;
import doggytalents.common.entity.serializers.DogSerializer;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class Dim2BlockPosSerializer
extends DogSerializer<Dimension2BlockPosMap> {
    @Override
    public void write(FriendlyByteBuf buf, Dimension2BlockPosMap value) {
        buf.writeInt(value.size());
        for (Map.Entry<ResourceKey<Level>, BlockPos> entry : value.entrySet()) {
            buf.writeResourceLocation(entry.getKey().location());
            EntityDataSerializers.BLOCK_POS.codec().encode((Object)((RegistryFriendlyByteBuf)buf), (Object)entry.getValue());
        }
    }

    @Override
    public Dimension2BlockPosMap read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        Dimension2BlockPosMap value = new Dimension2BlockPosMap();
        for (int i = 0; i < size; ++i) {
            ResourceLocation loc = buf.readResourceLocation();
            BlockPos pos = (BlockPos)EntityDataSerializers.BLOCK_POS.codec().decode((Object)((RegistryFriendlyByteBuf)buf));
            ResourceKey res_key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc);
            value.put((ResourceKey<Level>)res_key, pos);
        }
        return value;
    }

    public Dimension2BlockPosMap copy(Dimension2BlockPosMap value) {
        return value.copy();
    }
}

