/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.inventory.container.slot.DogInventorySlot;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class DogInventoriesContainer
extends AbstractContainerMenu {
    private Level level;
    private Player player;
    private DataSlot slotViewOffset;
    private final List<Dog> chestDogs;
    private final List<DogInventorySlot> dogSlots = new ArrayList<DogInventorySlot>();
    private int totalDogColsCount = 0;
    public static final int VIEW_OFFSET_DATA_ID = 0;
    private int dogSlotsStartsAt = 0;

    public DogInventoriesContainer(int windowId, Inventory playerInventory, List<Dog> chestDogs) {
        super(DoggyContainerTypes.DOG_INVENTORIES.get(), windowId);
        this.level = playerInventory.player.level();
        this.player = playerInventory.player;
        this.slotViewOffset = DataSlot.standalone();
        this.addDataSlot(this.slotViewOffset);
        this.chestDogs = chestDogs;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
        this.dogSlotsStartsAt = this.slots.size();
        this.addDogSlots();
    }

    public void addDogSlots() {
        int VIEWPORT_COLS = 9;
        int view_offset = this.slotViewOffset.get();
        int current_col = 0;
        for (Dog dog : this.chestDogs) {
            PackPuppyItemHandler packInventory = dog.getTalent(DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
            if (packInventory == null) continue;
            int dog_total_cols = Mth.clamp((int)dog.getDogLevel(DoggyTalents.PACK_PUPPY), (int)0, (int)5);
            for (int col = 0; col < dog_total_cols; ++col) {
                for (int row = 0; row < 3; ++row) {
                    boolean inside_of_viewport;
                    int slot_indx = col * 3 + row;
                    int abs_col = current_col + col;
                    int viewX = 8 + 18 * (current_col + col - view_offset);
                    int viewY = 18 * row + 18;
                    DogInventorySlot slot = new DogInventorySlot(dog, this.player, (IItemHandler)packInventory, abs_col, row, col, slot_indx, viewX, viewY);
                    this.addDogSlot(slot);
                    int viewport_col = slot.getAbsoluteCol() - view_offset;
                    boolean bl = inside_of_viewport = viewport_col >= 0 && viewport_col < 9;
                    if (inside_of_viewport) continue;
                    slot.setEnabled(false);
                }
            }
            this.totalDogColsCount += dog_total_cols;
            current_col += dog_total_cols;
        }
    }

    public void setData(int id, int data) {
        super.setData(id, data);
        if (id == 0) {
            this.reDrawDogSlots(data);
        }
    }

    private void reDrawDogSlots(int newViewOffset) {
        for (int i = 0; i < this.dogSlots.size(); ++i) {
            DogInventorySlot slot0 = this.dogSlots.get(i);
            DogInventorySlot new_slot = new DogInventorySlot(slot0, 8 + 18 * (slot0.getAbsoluteCol() - newViewOffset));
            this.replaceDogSlot(i, new_slot);
            int viewport_col = slot0.getAbsoluteCol() - newViewOffset;
            if (viewport_col >= 0 && viewport_col < 9) continue;
            new_slot.setEnabled(false);
        }
    }

    private void addDogSlot(DogInventorySlot slotIn) {
        this.addSlot((Slot)slotIn);
        this.dogSlots.add(slotIn);
    }

    private void replaceDogSlot(int i, DogInventorySlot slotIn) {
        this.dogSlots.set(i, slotIn);
        DogInventorySlot s = slotIn;
        this.slots.set(((Slot)s).index, (Object)slotIn);
    }

    public int getTotalNumColumns() {
        return this.totalDogColsCount;
    }

    public int getViewOffset() {
        return this.slotViewOffset.get();
    }

    public void setViewOffset(int offset) {
        this.setData(0, offset);
    }

    public List<DogInventorySlot> getSlots() {
        return this.dogSlots;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int i) {
        Slot slot = (Slot)this.slots.get(i);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack moveStack0 = ItemStack.EMPTY;
        ItemStack moveStack = slot.getItem();
        moveStack0 = moveStack.copy();
        boolean moveResult = false;
        boolean clickedDogSlot = i >= this.dogSlotsStartsAt && i < this.slots.size();
        moveResult = clickedDogSlot ? this.moveItemStackTo(moveStack, 0, this.dogSlotsStartsAt, true) : this.moveItemStackTo(moveStack, this.dogSlotsStartsAt, this.slots.size(), false);
        if (!moveResult) {
            return ItemStack.EMPTY;
        }
        if (moveStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (moveStack.getCount() == moveStack0.getCount()) {
            return ItemStack.EMPTY;
        }
        return moveStack0;
    }
}

