/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.network.packet.ParticlePackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EnergizerStick
extends Item
implements IDogFoodHandler {
    public EnergizerStick(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isFood(ItemStack stackIn) {
        return stackIn.getItem() == this;
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, Entity entityIn) {
        return !dog.isDefeated() && this.isFood(stackIn);
    }

    @Override
    public DogInteractionResult consume(AbstractDog dog, ItemStack stack, Entity entityIn) {
        if (!dog.level().isClientSide) {
            dog.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 1, false, true));
            dog.addEffect(new MobEffectInstance(MobEffects.SPEED, 200, 6, false, true));
            dog.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 2, false, true));
            dog.consumeItemFromStack(entityIn, stack);
            if (dog.level() instanceof ServerLevel) {
                ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)DoggyItems.ENERGIZER_STICK.get()));
            }
            dog.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), dog.getSoundVolume(), (dog.getRandom().nextFloat() - dog.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
        return DogInteractionResult.SUCCESS;
    }
}

