/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyAdvancementTriggers;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.DogEddibleItem;
import doggytalents.common.util.PlayerUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SakeItem
extends DogEddibleItem {
    public SakeItem(Item.Properties itemProps) {
        super(itemProps, b -> b.stacksTo(8).craftRemainder(Items.GLASS_BOTTLE), b -> b);
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, @Nullable Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (!(entityIn instanceof Player)) {
            return false;
        }
        Player player = (Player)entityIn;
        if (PlayerUtil.isOnCooldown(player, this)) {
            return false;
        }
        if (dog.getOwner() != player) {
            return false;
        }
        return !dog.isBaby() && super.canConsume(dog, stackIn, entityIn);
    }

    @Override
    public DogInteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        DogInteractionResult ret = super.consume(dog, stack, entityIn);
        this.mayBoostOrDrunkEntity((LivingEntity)dog, entityIn);
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            PlayerUtil.addCooldown(player, this, 40);
        }
        return ret;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack ret = stack;
        if (!(entity instanceof Player)) {
            return ret;
        }
        Player player = (Player)entity;
        if (!player.level().isClientSide) {
            this.mayBoostOrDrunkEntity((LivingEntity)player, null);
            PlayerUtil.addCooldown(player, this, 40);
        }
        if (!player.getAbilities().instabuild) {
            ret.shrink(1);
        }
        if (ret.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        ItemStack bonusReturnStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        Inventory inv = player.getInventory();
        int freeSlot = inv.getFreeSlot();
        if (freeSlot >= 0) {
            inv.add(bonusReturnStack);
        } else {
            player.spawnAtLocation((ServerLevel)level, bonusReturnStack);
        }
        return ret;
    }

    public InteractionResult use(Level p_42993_, Player p_42994_, InteractionHand p_42995_) {
        return ItemUtils.startUsingInstantly((Level)p_42993_, (Player)p_42994_, (InteractionHand)p_42995_);
    }

    @Override
    public SoundEvent getDogEatingSound(AbstractDog dog) {
        return (SoundEvent)SoundEvents.GENERIC_DRINK.value();
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41452_) {
        return ItemUseAnimation.DRINK;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 32;
    }

    @Override
    public boolean alwaysEatWhenDogConsume(AbstractDog dog) {
        return true;
    }

    @Override
    public ItemStack getReturnStackAfterDogConsume(ItemStack useStack, AbstractDog dog) {
        return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
    }

    private void mayBoostOrDrunkEntity(LivingEntity entity, @Nullable Entity feeder) {
        boolean drunk;
        float r = entity.getRandom().nextFloat();
        boolean bl = drunk = r <= 0.4f;
        if (!drunk) {
            if (!(entity instanceof Dog) && !(entity instanceof Player)) {
                return;
            }
            entity.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 1200, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.STRENGTH, 1200, 2));
            entity.addEffect(new MobEffectInstance(MobEffects.SPEED, 1200, 0));
            entity.addEffect(new MobEffectInstance(MobEffects.HASTE, 1200, 0));
            return;
        }
        int r_drunkTicks = 20 * (30 + entity.getRandom().nextInt(15));
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            if (feeder instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)feeder;
                DoggyAdvancementTriggers.DOG_DRUNK_TRIGGER.trigger(dog, sP);
            }
            dog.setDrunkTicks(r_drunkTicks);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            r_drunkTicks = 1200;
            if (player.getRandom().nextBoolean()) {
                r_drunkTicks *= 2;
            }
            player.removeEffect(MobEffects.SPEED);
            player.addEffect(new MobEffectInstance(MobEffects.NAUSEA, r_drunkTicks, 2));
            player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, r_drunkTicks, 3));
            player.addEffect(new MobEffectInstance(MobEffects.MINING_FATIGUE, r_drunkTicks, 1));
            player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, r_drunkTicks, 3));
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId() + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }
}

