/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Lists;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CodecUtil_1_21_7;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ValueOutputUtil_1_21_7;
import doggytalents.api.feature.DogMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class DogRespawnData
implements IDogData {
    private final DogRespawnStorage storage;
    private final UUID uuid;
    private UUID ownerUUID;
    private Optional<String> dogName = Optional.empty();
    private CompoundTag data;
    private DogIncapacitatedMananger.IncapacitatedSyncState killedBy = DogIncapacitatedMananger.IncapacitatedSyncState.NONE;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting", "ActiveEffects"});
    private static final List<String> IMPORTANT_TAGS = List.of("Owner", "friendlyFire", "UUID", "talents", "level_normal", "level_kami", "dogGender", "dogSize", "entityKills", "accessories", "doggytalents_dog_skin");
    private static final String STORAGE_AGE_TAG = "DogRespawn_Age";
    private static final String STORAGE_OWNER_TAG = "DogRespawn_ownerUUID";
    private static final String STORAGE_NAME_TAG = "DogRespawn_dogName";

    protected DogRespawnData(DogRespawnStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    public String getDogName() {
        String name = this.dogName.orElse(null);
        return name == null ? "noname" : name;
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    public void populate(Dog dogIn) {
        DataStrategy strategy;
        Optional<DamageSource> deathCauseOptional;
        this.data = new CompoundTag();
        this.ownerUUID = dogIn.getOwnerUUID();
        Component customName = dogIn.getCustomName();
        if (customName != null) {
            this.dogName = Optional.ofNullable(customName.getString());
        }
        if ((deathCauseOptional = dogIn.getDogDeathCause()).isPresent()) {
            this.killedBy = dogIn.createIncapSyncState(deathCauseOptional.get());
        }
        if ((strategy = this.fetchDataStrategy()) == DataStrategy.KEEP_ALL_EXCEPT) {
            this.writeAlldataAndRemoveSpecific(dogIn, this.data);
        } else {
            this.writeImportantDataToKeep(dogIn, this.data);
        }
        this.data.remove("UUID");
        this.data.remove("LoveCause");
        this.data.remove("DTN_DupeDetect");
    }

    private void writeAlldataAndRemoveSpecific(Dog dog, CompoundTag target) {
        dog.saveWithoutId(target);
        for (String tag : TAGS_TO_REMOVE) {
            target.remove(tag);
        }
        target.remove(STORAGE_AGE_TAG);
        target.remove(STORAGE_OWNER_TAG);
        target.remove(STORAGE_NAME_TAG);
        try {
            List extraTagsToRemove = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_REMOVE.get();
            for (String tag : extraTagsToRemove) {
                if (IMPORTANT_TAGS.contains(tag)) continue;
                target.remove(tag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeImportantDataToKeep(Dog dog, CompoundTag target) {
        Component custom_name;
        dog.addDTNAdditionalSavedData(target);
        target.putInt(STORAGE_AGE_TAG, dog.getAge());
        UUID owner_uuid = dog.getOwnerUUID();
        if (owner_uuid != null) {
            CompoundTag_1_21_5.wrap(target).putUUID(STORAGE_OWNER_TAG, owner_uuid);
        }
        if ((custom_name = dog.getCustomName()) != null) {
            target.putString(STORAGE_NAME_TAG, CodecUtil_1_21_7.encodeComponentToStr(custom_name, (HolderLookup.Provider)dog.registryAccess()));
        }
        this.keepAdditionalTag(target, dog);
    }

    private void keepAdditionalTag(CompoundTag target, Dog dog) {
        try {
            List extraTagsToKeep = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_KEEP.get();
            if (extraTagsToKeep == null || extraTagsToKeep.isEmpty()) {
                return;
            }
            CompoundTag nonDTNTags = new CompoundTag();
            ValueOutputUtil_1_21_7.outputValueOutputTo(nonDTNTags, (HolderLookup.Provider)dog.registryAccess(), nonDTNTags_1_21_7 -> dog.addNonDTNAdditionalData((ValueOutput)nonDTNTags_1_21_7));
            for (String toKeepStr : extraTagsToKeep) {
                if (!nonDTNTags.contains(toKeepStr) || target.contains(toKeepStr)) continue;
                Tag toKeep = nonDTNTags.get(toKeepStr).copy();
                target.put(toKeepStr, toKeep);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restoreAndConsumeImportantDataIfNeeded(Dog dog, CompoundTag_1_21_5 tag) {
        if (tag.contains(STORAGE_AGE_TAG, 3)) {
            dog.setAge(tag.getInt(STORAGE_AGE_TAG));
            tag.remove(STORAGE_AGE_TAG);
        }
        if (tag.hasUUID(STORAGE_OWNER_TAG)) {
            UUID correct_owner_uuid = this.ownerUUID;
            try {
                correct_owner_uuid = tag.getUUID(STORAGE_OWNER_TAG);
            }
            catch (Exception exception) {
                // empty catch block
            }
            dog.setOwnerUUID(correct_owner_uuid);
            dog.setTame(correct_owner_uuid != null, true);
            tag.remove(STORAGE_OWNER_TAG);
        }
        if (tag.contains(STORAGE_NAME_TAG)) {
            try {
                String name_c1_str = tag.getString(STORAGE_NAME_TAG);
                dog.setDogCustomName(CodecUtil_1_21_7.parseComponentFromStr(name_c1_str, (HolderLookup.Provider)dog.registryAccess()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            tag.remove(STORAGE_NAME_TAG);
        }
    }

    @Nullable
    public Dog respawn(ServerLevel worldIn, Player playerIn, BlockPos pos) {
        Dog dog = (Dog)DoggyEntityTypes.DOG.get().create((Level)worldIn, EntitySpawnReason.LOAD);
        if (dog == null) {
            return null;
        }
        dog.snapTo(Vec3.atBottomCenterOf((Vec3i)pos));
        this.restoreAndConsumeImportantDataIfNeeded(dog, CompoundTag_1_21_5.wrap(this.data));
        CompoundTag compoundnbt = dog.saveWithoutId(new CompoundTag());
        UUID uuid = dog.getUUID();
        compoundnbt.merge(this.data);
        dog.load(compoundnbt);
        boolean useOldUUID = (Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get() == false && worldIn.getEntity(this.uuid) == null;
        dog.setUUID(useOldUUID ? this.uuid : uuid);
        dog.setOrderedToSit(true);
        if (this.killedBy != null && this.killedBy != DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            if (dog.getDogIncapValue() <= 0) {
                dog.setDogIncapValue(dog.getDefaultInitIncapVal());
            }
            dog.setDogHunger(0.0f);
            dog.setMode(DogMode.INJURED);
            dog.setHealth(1.0f);
            dog.setIncapSyncState(this.killedBy);
            if (dog.isInWater() || dog.isInLava()) {
                dog.triggerAnimationAction(new DogDrownAction(dog));
            } else {
                dog.setAnim(dog.incapacitatedMananger.getAnim());
            }
        } else {
            dog.setMode(DogMode.DOCILE);
            dog.setAnim(DogAnimation.STAND_QUICK);
            dog.maxHealth();
        }
        DogDuplicationDetection.onAboutToRespawn(dog);
        worldIn.addFreshEntityWithPassengers((Entity)dog);
        DogLocationStorage.setSessionUUIDFor(dog, uuid);
        return dog;
    }

    public void read(CompoundTag_1_21_5 compound) {
        this.data = compound.getCompound("data").wrapped();
        if (compound.contains("dog_name", 8)) {
            try {
                String name_str = compound.getString("dog_name");
                this.dogName = Optional.ofNullable(name_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compound.hasUUID("owner_uuid")) {
            this.ownerUUID = compound.getUUID("owner_uuid");
        }
        this.readKilledBy(compound);
    }

    public CompoundTag write(CompoundTag compound) {
        compound.put("data", (Tag)this.data);
        if (this.dogName.isPresent()) {
            compound.putString("dog_name", this.dogName.get());
        }
        if (this.ownerUUID != null) {
            CompoundTag_1_21_5.wrap(compound).putUUID("owner_uuid", this.ownerUUID);
        }
        this.writeKilledBy(compound);
        return compound;
    }

    public void writeKilledBy(CompoundTag compound) {
        if (this.killedBy == DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            return;
        }
        if (this.killedBy == null) {
            return;
        }
        CompoundTag killedByTag = new CompoundTag();
        killedByTag.putInt("typeId", this.killedBy.type.getId());
        killedByTag.putInt("poseId", this.killedBy.poseId);
        compound.put("dog_killed_by", (Tag)killedByTag);
    }

    public void readKilledBy(CompoundTag_1_21_5 compound) {
        if (!compound.contains("dog_killed_by", 10)) {
            return;
        }
        CompoundTag_1_21_5 killedByTag = compound.getCompound("dog_killed_by");
        int typeId = killedByTag.getInt("typeId");
        int poseId = killedByTag.getInt("poseId");
        this.killedBy = new DogIncapacitatedMananger.IncapacitatedSyncState(DogIncapacitatedMananger.DefeatedType.byId(typeId), DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private DataStrategy fetchDataStrategy() {
        Integer stategy_int = (Integer)ConfigHandler.RespawnTagConfig.getConfig(ConfigHandler.RESPAWN_TAGS.STRATEGY);
        if (stategy_int != 1) {
            return DataStrategy.REMOVE_ALL_EXCEPT;
        }
        return DataStrategy.KEEP_ALL_EXCEPT;
    }

    private static enum DataStrategy {
        REMOVE_ALL_EXCEPT,
        KEEP_ALL_EXCEPT;

    }
}

