/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class DoggyArmorTalent
extends TalentInstance {
    protected int tickUntilXPSearch;
    protected final int SEARCH_RADIUS = 2;
    protected int spareValue;
    private boolean mayNeedsDataUpgrade = false;

    public DoggyArmorTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.level().isClientSide) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            this.dropArmor(dog);
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.merge(dogIn.dogArmors().serializeNBT((HolderLookup.Provider)dogIn.registryAccess()));
        compound.putInt("armors_spareXp", this.level);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        try {
            dogIn.dogArmors().deserializeNBT((HolderLookup.Provider)dogIn.registryAccess(), compound.wrapped());
            if (compound.contains("armors_spareXp")) {
                this.spareValue = compound.getInt("armors_spareXp");
                this.mayNeedsDataUpgrade = false;
            } else {
                this.spareValue = 0;
                this.mayNeedsDataUpgrade = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onRead(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        if (!this.mayNeedsDataUpgrade) {
            return;
        }
        try {
            if (compound.contains("dogArmors", 9)) {
                dogIn.dogArmors().deserializeNBT((HolderLookup.Provider)dogIn.registryAccess(), compound.wrapped());
            }
            this.spareValue = compound.getInt("armors_spareXp");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
    }

    private void dropArmor(AbstractDog dogIn) {
        for (int i = 0; i < dogIn.dogArmors().getSlots(); ++i) {
            Containers.dropItemStack((Level)dogIn.level(), (double)dogIn.getX(), (double)dogIn.getY(), (double)dogIn.getZ(), (ItemStack)dogIn.dogArmors().getStackInSlot(i));
            dogIn.dogArmors().setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (ItemUtil_1_21_5.isHumanoidArmor(playerIn.getMainHandItem())) {
            LivingEntity owner;
            if (!(dogIn instanceof Dog)) {
                return DogInteractionResult.PASS;
            }
            if (!worldIn.isClientSide && (owner = dogIn.getOwner()) instanceof ServerPlayer) {
                ServerPlayer sOwner = (ServerPlayer)owner;
                Screens.openArmorScreen(sOwner, (Dog)dogIn);
            }
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() >= 3) {
            this.scanForXpAndRepair(dog);
        }
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanWearArmor();
    }

    private void scanForXpAndRepair(AbstractDog dog) {
        if (dog.level().isClientSide) {
            return;
        }
        if (--this.tickUntilXPSearch <= 0) {
            this.tickUntilXPSearch = 10;
            Optional entry = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)dog, ItemStack::isDamaged);
            if (!entry.isPresent()) {
                return;
            }
            Level level = dog.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel sLevel = (ServerLevel)level;
            EnchantedItemInUse enchant_stack = (EnchantedItemInUse)entry.get();
            ItemStack itemstack = enchant_stack.itemStack();
            if (this.spareValue > 0) {
                int i = Math.min((int)((float)this.spareValue * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
                i = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)sLevel, (ItemStack)itemstack, (int)i);
                itemstack.setDamageValue(itemstack.getDamageValue() - i);
                this.spareValue = (int)((float)this.spareValue - (float)i / itemstack.getXpRepairRatio());
            }
            if (!itemstack.isDamaged()) {
                return;
            }
            List orbs = dog.level().getEntitiesOfClass(ExperienceOrb.class, dog.getBoundingBox().inflate(2.0));
            for (ExperienceOrb x : orbs) {
                if (itemstack.getDamageValue() <= 0) break;
                int j = Math.min((int)((float)x.getValue() * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
                j = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)sLevel, (ItemStack)itemstack, (int)j);
                itemstack.setDamageValue(itemstack.getDamageValue() - j);
                dog.take((Entity)x, 1);
                this.spareValue = (int)((float)this.spareValue + (float)j / itemstack.getXpRepairRatio());
                x.discard();
            }
        }
    }
}

