/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import doggytalents.client.PettingArmPose;
import doggytalents.client.backward_imitate.PlayerRenderPrep_21_3;
import doggytalents.client.screen.PetSelectScreen;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.fabric_helper.util.FabricUtil;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogPettingData;
import doggytalents.common.util.EntityUtil;
import doggytalents.forge_imitate.event.client.ClientPlayerNetworkEvent;
import doggytalents.forge_imitate.event.client.ClientTickEvent;
import doggytalents.forge_imitate.event.client.ComputeCameraAngles;
import doggytalents.forge_imitate.event.client.InputEvent;
import doggytalents.forge_imitate.event.client.MovementInputUpdateEvent;
import doggytalents.forge_imitate.event.client.RenderArmEvent;
import doggytalents.forge_imitate.event.client.RenderPlayerEvent;
import doggytalents.forge_imitate.network.PacketDistributor;
import doggytalents.mixin.CameraMixinAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10185;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5498;
import net.minecraft.class_572;
import net.minecraft.class_744;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class DTNClientPettingManager {
    private static DTNClientPettingManager INSTANCE = new DTNClientPettingManager();
    private DogPettingManager.DogPettingType selectedType = null;
    private Dog dog = null;
    private boolean isPetting;
    private float pet_camera_xRot_add = 0.0f;
    private float pet_camera_yRot_add = 0.0f;
    private float pet_camera_xRot0_add = 0.0f;
    private float pet_camera_yRot0_add = 0.0f;
    private final Map<UUID, Dog> petterMap = Maps.newHashMap();
    private final List<UUID> toRemoveForPetter = new ArrayList<UUID>();

    public static DTNClientPettingManager get() {
        return INSTANCE;
    }

    public void setPetMode(DogPettingManager.DogPettingType type) {
        this.selectedType = type;
    }

    public DogPettingManager.DogPettingType getPetMode() {
        return this.selectedType;
    }

    public void setPetting(Dog dog) {
        this.isPetting = dog != null;
        this.dog = dog;
        if (!this.isPetting) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        player.field_6283 = player.field_6241;
        this.pet_camera_xRot_add = 0.0f;
        this.pet_camera_yRot_add = 0.0f;
        this.pet_camera_xRot0_add = 0.0f;
        this.pet_camera_yRot0_add = 0.0f;
    }

    public void tickClient(ClientTickEvent event) {
        if (event.phase != ClientTickEvent.Phase.END) {
            return;
        }
        if (this.isPetting) {
            this.updatePetCameraRotation();
        }
        this.invalidatePetterCache();
    }

    public void onPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.clearPetterMap();
    }

    public void invalidatePetterCache() {
        if (this.petterMap.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, Dog> entry : this.petterMap.entrySet()) {
            Dog dog = entry.getValue();
            if (dog.method_5805()) continue;
            this.toRemoveForPetter.add(entry.getKey());
        }
        if (this.toRemoveForPetter.isEmpty()) {
            return;
        }
        for (UUID player : this.toRemoveForPetter) {
            this.removePetterFromMap(player);
        }
        this.toRemoveForPetter.clear();
    }

    private void updatePetCameraRotation() {
        class_310 mc = class_310.method_1551();
        class_315 options = mc.field_1690;
        class_5498 view_type = options.method_31044();
        if (view_type.method_31034()) {
            return;
        }
        this.pet_camera_xRot0_add = this.pet_camera_xRot_add;
        this.pet_camera_yRot0_add = this.pet_camera_yRot_add;
        float add_amount = 3.0f;
        if (options.field_1894.method_1434()) {
            this.pet_camera_xRot_add += 3.0f;
        } else if (options.field_1881.method_1434()) {
            this.pet_camera_xRot_add -= 3.0f;
        } else if (options.field_1913.method_1434()) {
            this.pet_camera_yRot_add += 3.0f;
        } else if (options.field_1849.method_1434()) {
            this.pet_camera_yRot_add -= 3.0f;
        }
        this.pet_camera_xRot_add = class_3532.method_15363((float)this.pet_camera_xRot_add, (float)-50.0f, (float)50.0f);
        float y_rot_change = this.pet_camera_yRot_add - this.pet_camera_yRot0_add;
        this.pet_camera_yRot_add = class_3532.method_15393((float)this.pet_camera_yRot_add);
        this.pet_camera_yRot0_add = this.pet_camera_yRot_add - y_rot_change;
    }

    public void onRenderHand(RenderArmEvent event) {
        if (event.getArm() != class_1306.field_6183) {
            return;
        }
        if (!this.isPetting) {
            return;
        }
        class_4587 stack = event.getPoseStack();
        class_310 mc = class_310.method_1551();
        float pTicks = FabricUtil.getPartialTick(mc);
        class_1657 player = event.getPlayer();
        float anim_timeline = ((float)(player.field_6012 + player.method_5628()) + pTicks) * 0.04f;
        float occill = class_3532.method_15374((float)(anim_timeline * 2.0f * (float)Math.PI));
        float rotating_x = -15.0f * occill;
        DogPettingManager.DogPettingType petting_type = this.getPettingTypeFor((class_1309)player);
        if (petting_type == DogPettingManager.DogPettingType.HUG || petting_type == DogPettingManager.DogPettingType.BACK_HUG) {
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-20.0f));
            stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(0.0f));
            stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(60.0f));
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-10.0f + rotating_x));
            stack.method_22904(0.0, 0.2, -0.6);
        } else {
            stack.method_22904(0.0, 0.4, 0.0);
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-57.0f));
            stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(0.0f));
            stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-30.0f));
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(rotating_x));
        }
    }

    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (this.selectedType == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int button = event.getButton();
        if (!mc.field_1690.field_1904.method_1433(button)) {
            return;
        }
        if (mc.field_1755 != null || mc.method_18506() != null || mc.field_1724 == null) {
            return;
        }
        int action = event.getAction();
        if (this.handleStopPetting(action)) {
            event.setCanceled(true);
            return;
        }
        Optional<Dog> dog_optional = this.getLookingDog();
        if (!dog_optional.isPresent()) {
            return;
        }
        if (this.handleStartPetting(action, dog_optional.get(), (class_1657)mc.field_1724)) {
            event.setCanceled(true);
            return;
        }
        if (this.handleOpenPettingScreen(action, dog_optional.get(), (class_1657)mc.field_1724)) {
            event.setCanceled(true);
            return;
        }
    }

    private boolean handleStopPetting(int action) {
        if (!this.isPetting) {
            return false;
        }
        if (action == 1) {
            return false;
        }
        if (this.dog != null) {
            this.requestPetting(this.dog, false);
        } else {
            this.setPetting(null);
        }
        return true;
    }

    private boolean handleStartPetting(int action, Dog dog, class_1657 player) {
        if (this.isPetting) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        if (!player.method_5715()) {
            return false;
        }
        if (!dog.pettingManager.canPet(player)) {
            return false;
        }
        this.requestPetting(dog, true);
        return true;
    }

    private boolean handleOpenPettingScreen(int action, Dog dog, class_1657 player) {
        if (this.isPetting) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        if (player.method_5715()) {
            return false;
        }
        if (!dog.pettingManager.isInPetDistance(dog, player)) {
            return false;
        }
        if (!EntityUtil.allHandEmpty((class_1309)player)) {
            return false;
        }
        PetSelectScreen.open();
        return true;
    }

    private Optional<Dog> getLookingDog() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return Optional.empty();
        }
        class_239 hitResult = mc.field_1765;
        if (hitResult == null) {
            return Optional.empty();
        }
        if (!(hitResult instanceof class_3966)) {
            return Optional.empty();
        }
        class_3966 entityHit = (class_3966)hitResult;
        class_1297 entity = entityHit.method_17782();
        if (!(entity instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)entity;
        return Optional.of(dog);
    }

    private DogPettingManager.DogPettingType getPettingTypeFor(class_1309 player) {
        UUID id = player.method_5667();
        Dog dog = this.petterMap.get(id);
        if (dog == null) {
            return DogPettingManager.DogPettingType.FACERUB;
        }
        return dog.getPettingState().type();
    }

    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (PlayerRenderPrep_21_3.player == null) {
            return;
        }
        if (!this.isPettingPlayer(PlayerRenderPrep_21_3.player)) {
            return;
        }
        PettingArmPose.activateLeft = true;
        PettingArmPose.activateRight = true;
    }

    private boolean isPettingPlayer(class_1657 player) {
        if (this.petterMap.isEmpty()) {
            return false;
        }
        Dog dog = this.petterMap.get(player.method_5667());
        return dog != null && dog.pettingManager.isInPetDistance(dog, player);
    }

    public void applyTransform(class_572<?> model, class_1309 player, class_1306 arm) {
        class_310 mc = class_310.method_1551();
        float pTicks = FabricUtil.getPartialTick(mc);
        float anim_timeline = ((float)(player.method_5628() + player.field_6012) + pTicks) * 0.04f;
        DogPettingManager.DogPettingType petting_type = this.getPettingTypeFor(player);
        if (petting_type == DogPettingManager.DogPettingType.HUG || petting_type == DogPettingManager.DogPettingType.BACK_HUG) {
            if (arm == class_1306.field_6183) {
                float occill = class_3532.method_15374((float)(anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.field_3401.field_3654 = -1.3089969f;
                model.field_3401.field_3654 += rotating_x * ((float)Math.PI / 180);
                model.field_3401.field_3675 = -0.06981317f;
            } else if (arm == class_1306.field_6182) {
                float occill = class_3532.method_15374((float)((float)Math.PI + anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.field_27433.field_3654 = -1.3089969f;
                model.field_27433.field_3654 += rotating_x * ((float)Math.PI / 180);
                model.field_27433.field_3675 = 0.06981317f;
            }
        } else if (petting_type == DogPettingManager.DogPettingType.BELLY_RUB) {
            if (arm == class_1306.field_6183) {
                float occill = class_3532.method_15374((float)(anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.field_3401.field_3654 = -1.0471976f;
                model.field_3401.field_3654 += rotating_x * ((float)Math.PI / 180);
                model.field_3401.field_3675 = -0.34906584f;
            } else if (arm == class_1306.field_6182) {
                float occill = class_3532.method_15374((float)((float)Math.PI + anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.field_27433.field_3654 = -1.0471976f;
                model.field_27433.field_3654 += rotating_x * ((float)Math.PI / 180);
                model.field_27433.field_3675 = 0.34906584f;
            }
        } else if (arm == class_1306.field_6183) {
            float occill = class_3532.method_15374((float)(anim_timeline * 12.0f));
            float rotating_x = 15.0f * occill;
            model.field_3401.field_3654 = -2.0071287f;
            model.field_3401.field_3675 = -0.5235988f;
            model.field_3401.field_3675 += rotating_x * ((float)Math.PI / 180);
        }
    }

    public void modifyCameraAngle(ComputeCameraAngles event) {
        if (!this.isPetting) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_5498 view_type = mc.field_1690.method_31044();
        if (view_type.method_31034()) {
            return;
        }
        float pTicks = FabricUtil.getPartialTick(mc);
        float camera_xRot = class_3532.method_16439((float)pTicks, (float)this.pet_camera_xRot0_add, (float)this.pet_camera_xRot_add);
        camera_xRot = class_3532.method_15363((float)camera_xRot, (float)-75.0f, (float)75.0f);
        event.setPitch(camera_xRot);
        event.setYaw(event.getYaw() + class_3532.method_16439((float)pTicks, (float)this.pet_camera_yRot0_add, (float)this.pet_camera_yRot_add));
        this.fixCameraPosition_1_20_under(event.getCamera(), FabricUtil.getPartialTick(mc), event.getYaw(), event.getPitch());
    }

    public void onMovementInput(MovementInputUpdateEvent event) {
        if (!this.isPetting) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_315 options = mc.field_1690;
        class_5498 view_type = options.method_31044();
        if (view_type.method_31034()) {
            return;
        }
        class_744 input = event.getInput();
        class_10185 input_21_3_old = input.field_54155;
        input.field_54155 = new class_10185(false, false, false, false, input_21_3_old.comp_3163(), input_21_3_old.comp_3164(), input_21_3_old.comp_3165());
        input.field_55868 = class_241.field_1340;
    }

    public void onPettingUpdate(Dog dog, DogPettingManager.DogPettingState state) {
        if (!state.is_petting()) {
            this.clearPettingFor(dog);
            return;
        }
        UUID petter_id = state.petting_id();
        this.addPetterToMap(petter_id, dog);
    }

    private void clearPettingFor(Dog dog) {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Dog> entry : this.petterMap.entrySet()) {
            if (entry.getValue() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.removePetterFromMap(key);
        }
    }

    private void addPetterToMap(UUID petter, Dog dog) {
        if (dog == null || petter == null) {
            return;
        }
        this.petterMap.put(petter, dog);
        if (this.isSelfUUID(petter)) {
            this.setPetting(dog);
        }
    }

    private void removePetterFromMap(UUID petter) {
        if (petter == null) {
            return;
        }
        this.petterMap.remove(petter);
        if (this.isSelfUUID(petter)) {
            this.setPetting(null);
        }
    }

    private void clearPetterMap() {
        this.petterMap.clear();
        this.setPetting(null);
    }

    private boolean isSelfUUID(UUID petter) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        return player != null && Objects.equal((Object)player.method_5667(), (Object)petter);
    }

    private void requestPetting(Dog dog, boolean pet) {
        if (pet) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogPettingData(dog.method_5628(), true, this.selectedType));
        } else {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogPettingData(dog.method_5628(), false, null));
        }
    }

    private void fixCameraPosition_1_20_under(class_4184 camera, double pTicks, float new_yRot, float new_xRot) {
        float f;
        class_310 mc = class_310.method_1551();
        class_1297 camera_entity = mc.method_1560();
        if (camera_entity == null) {
            camera_entity = mc.field_1724;
        }
        if (camera_entity == null) {
            return;
        }
        ((CameraMixinAccessor)camera).dtn__setRotation(new_yRot, new_xRot);
        ((CameraMixinAccessor)camera).dtn__setPosition(class_3532.method_16436((double)pTicks, (double)camera_entity.field_6014, (double)camera_entity.method_23317()), class_3532.method_16436((double)pTicks, (double)camera_entity.field_6036, (double)camera_entity.method_23318()) + (double)camera_entity.method_5751(), class_3532.method_16436((double)pTicks, (double)camera_entity.field_5969, (double)camera_entity.method_23321()));
        if (camera_entity instanceof class_1309) {
            class_1309 living = (class_1309)camera_entity;
            f = living.method_55693();
        } else {
            f = 1.0f;
        }
        float scale = f;
        ((CameraMixinAccessor)camera).dtn__move(-((CameraMixinAccessor)camera).dtn__getMaxZoom(4.0f * scale), 0.0f, 0.0f);
    }
}

