/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.google.common.collect.Maps;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerScreen
extends StringEntrySelectScreen {
    private class_1657 player;
    private final ArrayList<String> dogNameList = new ArrayList();
    private final ArrayList<UUID> dogIdList = new ArrayList();
    private final Map<UUID, Integer> dogDistanceMap = Maps.newHashMap();
    private final Map<UUID, class_2338> dogPosMap = Maps.newHashMap();
    private boolean showUuid = false;

    public CanineTrackerScreen(class_1657 player) {
        super((class_2561)class_2561.method_43471((String)"doggytalents.screen.conducting_bone"));
        this.player = player;
    }

    public static void open() {
        class_310 mc = class_310.method_1551();
        CanineTrackerScreen screen = new CanineTrackerScreen((class_1657)mc.field_1724);
        mc.method_1507((class_437)screen);
        screen.requestDogs();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.field_22789 / 2;
        int mY = this.field_22790 / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(mX - 100 - 60 - 2, pY, 60, 20, (class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.method_25355((class_2561)class_2561.method_43471((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, pY += showUuid.method_25364() + 2, 20, 20, (class_2561)class_2561.method_43470((String)"?"), b -> {}){

            @Override
            public void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
                super.method_48579(graphics, mouseX, mouseY, pTicks);
                if (!this.field_22762) {
                    return;
                }
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                list.add((class_2561)class_2561.method_43471((String)"doggytalents.screen.radar.help_title").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                String str = class_1074.method_4662((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, CanineTrackerScreen.this.field_22793));
                ScreenUtil.renderComponentTooltip_21_5(graphics, CanineTrackerScreen.this.field_22793, list, mouseX, mouseY);
            }
        };
        this.method_37063((class_364)showUuid);
        this.method_37063((class_364)help);
    }

    @Override
    protected void drawEntry(class_332 graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        super.drawEntry(graphics, entry_x, entry_y, entry_id, is_selected);
        int textx1 = this.field_22789 / 2 + 100 - 35;
        UUID dogId = this.dogIdList.get(entry_id);
        int dist = this.dogDistanceMap.get(dogId);
        Object text1 = dist > 99999 ? "far" : "" + dist;
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        graphics.method_25303(this.field_22793, (String)text1, textx1, entry_y, color);
    }

    @Override
    protected void drawNoEntryMsg(class_332 graphics, int x, int y) {
        graphics.method_25303(this.field_22793, class_1074.method_4662((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        UUID uuid = this.dogIdList.get(entry_id);
        class_5250 uuid_c1 = class_2561.method_43470((String)uuid.toString()).method_27692(class_124.field_1080);
        if (this.field_22790 >= 273) {
            int mX = this.field_22789 / 2;
            int mY = this.field_22790 / 2;
            int uuid_width = this.field_22793.method_27525((class_5348)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.method_27535(this.field_22793, (class_2561)uuid_c1, tX, tY, -1);
        } else {
            ScreenUtil.renderComponentTooltip_21_5(graphics, this.field_22793, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void onEntrySelected(int id) {
        UUID uuid = this.dogIdList.get(id);
        this.startLocateDog(uuid);
        class_310.method_1551().method_1507(null);
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestDogsData());
    }

    public void assignResponse(List<Triple<UUID, String, class_2338>> dogLs) {
        this.dogNameList.clear();
        this.dogIdList.clear();
        this.dogDistanceMap.clear();
        this.dogPosMap.clear();
        for (Triple<UUID, String, class_2338> entry : dogLs) {
            this.dogNameList.add((String)entry.getMiddle());
            this.dogIdList.add((UUID)entry.getLeft());
            class_2338 pos = (class_2338)entry.getRight();
            int distance = class_3532.method_15386((float)class_3532.method_15355((float)((float)this.player.method_24515().method_10262((class_2382)pos))));
            this.dogDistanceMap.put((UUID)entry.getLeft(), distance);
            this.dogPosMap.put((UUID)entry.getLeft(), pos);
        }
        this.updateEntries(this.dogNameList);
    }

    private void startLocateDog(UUID uuid) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.StartLocatingData(uuid));
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}

