/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.client.entity.sound.DogInterruptibleSoundInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogInterruptibleSoundData;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class DogSoundManager {
    private final Dog dog;
    private boolean ambientVoiceLock = false;
    private final DogInterruptibleSoundInstanceRef interruptListener = new DogInterruptibleSoundInstanceRef();

    public DogSoundManager(Dog dog) {
        this.dog = dog;
    }

    public void setAmbientLocked(boolean val) {
        this.ambientVoiceLock = val;
    }

    public boolean isAmbientLocked() {
        return this.ambientVoiceLock;
    }

    public void tick() {
    }

    public void playInterruptible(class_3414 event, float volume, float pitch) {
        if (this.dog.method_5701()) {
            return;
        }
        DogInterruptibleSoundData data = new DogInterruptibleSoundData(this.dog.method_5628(), Optional.of(event), volume, pitch);
        if (this.dog.method_37908().field_9236) {
            this.onDogInterruptableSoundUpdate(data);
        } else {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.dog), data);
        }
    }

    public void playNonInterruptible(class_3414 event, float volume, float pitch) {
        if (this.dog.method_5701()) {
            return;
        }
        if (this.dog.method_37908().field_9236) {
            return;
        }
        this.dog.method_37908().method_43129(null, (class_1297)this.dog, event, class_3419.field_15256, volume, pitch);
    }

    public void interuptPlaying() {
        DogInterruptibleSoundData data = DogInterruptibleSoundData.stop(this.dog.method_5628());
        if (this.dog.method_37908().field_9236) {
            this.onDogInterruptableSoundUpdate(data);
        } else {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.dog), data);
        }
    }

    public void onDogInterruptableSoundUpdate(DogInterruptibleSoundData data) {
        DogInterruptibleSoundInstance clientSound = this.interruptListener.getOrNull();
        if (clientSound != null) {
            clientSound.dogInterupt();
        }
        if (!data.sound().isPresent()) {
            this.interruptListener.resetRef();
            return;
        }
        clientSound = DogInterruptibleSoundInstance.createAndPlayClient(this.dog, data.sound().get(), data.volume(), data.pitch());
        this.interruptListener.setRef(clientSound);
    }

    private static class DogInterruptibleSoundInstanceRef {
        private WeakReference<DogInterruptibleSoundInstance> ref = null;

        public DogInterruptibleSoundInstance getOrNull() {
            if (this.ref == null) {
                return null;
            }
            DogInterruptibleSoundInstance inst = (DogInterruptibleSoundInstance)((Object)this.ref.get());
            if (inst == null) {
                this.resetRef();
            }
            return inst;
        }

        public void setRef(DogInterruptibleSoundInstance inst) {
            this.ref = inst != null ? new WeakReference<DogInterruptibleSoundInstance>(inst) : null;
        }

        public void resetRef() {
            this.setRef(null);
        }
    }
}

