/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class DogThrownTrident
extends class_1665 {
    private static final int loyalty_amount = 3;
    private boolean isReturning;
    private boolean playedClientReturnSound;
    private int timeOutTick = 0;

    public DogThrownTrident(class_1299<DogThrownTrident> p_37561_, class_1937 p_37562_) {
        super(p_37561_, p_37562_);
    }

    public DogThrownTrident(Dog dog, class_1799 trident_stack) {
        super(DoggyEntityTypes.DOG_TRIDENT_PROJ.get(), (class_1309)dog, dog.method_37908(), trident_stack, null);
    }

    protected void method_5693(class_2945.class_9222 p_326249_) {
        super.method_5693(p_326249_);
    }

    public void method_5773() {
        Optional<Dog> return_owner_optional = this.getDogOwnerForReturn();
        if (!this.method_37908().field_9236 && this.doDogTridentInvalidateSelf(return_owner_optional)) {
            return;
        }
        if (return_owner_optional.isPresent()) {
            Dog return_owner = return_owner_optional.get();
            this.updateReturning(return_owner);
            if (this.isReturning) {
                this.returnToDog(return_owner);
            }
        }
        super.method_5773();
    }

    private void updateReturning(Dog return_dog) {
        if (this.isReturning) {
            return;
        }
        if (this.field_7576 > 1 || this.method_7441()) {
            this.switchToReturnToDog();
            return;
        }
    }

    private void returnToDog(Dog return_dog) {
        this.method_7433(true);
        class_243 pos = this.method_19538();
        class_243 dog_pos = return_dog.method_33571();
        class_243 v_self_dog = dog_pos.method_1020(pos);
        class_243 current_move_vec = this.method_18798();
        double l_current_move_vec = current_move_vec.method_1033();
        float max_speed = 1.2f;
        double acceleration = 0.15000000000000002;
        double return_speed = class_3532.method_15350((double)(l_current_move_vec + 0.15000000000000002), (double)0.0, (double)1.2f);
        class_243 return_vec = v_self_dog.method_1029().method_1021(return_speed);
        this.method_18799(return_vec);
        if (!this.playedClientReturnSound) {
            this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
            this.playedClientReturnSound = true;
        }
    }

    private void switchToReturnToDog() {
        this.isReturning = true;
    }

    private boolean doDogTridentInvalidateSelf(Optional<Dog> return_dog_optional) {
        ++this.timeOutTick;
        if (this.timeOutTick > DogThrownTrident.getDogTridentTimeout()) {
            this.method_31472();
            return true;
        }
        if (!return_dog_optional.isPresent()) {
            this.method_31472();
            return true;
        }
        Dog return_dog = return_dog_optional.get();
        if (this.isReturning && return_dog.method_5858((class_1297)this) <= 4.0) {
            this.method_31472();
            return true;
        }
        return false;
    }

    public Optional<Dog> getDogOwnerForReturn() {
        class_1297 owner = this.method_24921();
        if (!(owner instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)owner;
        if (!dog.isDoingFine()) {
            return Optional.empty();
        }
        if (dog.method_5858((class_1297)this) > 900.0) {
            return Optional.empty();
        }
        if (dog.method_6172()) {
            return Optional.empty();
        }
        return Optional.of(dog);
    }

    public boolean isFoil() {
        return true;
    }

    @Nullable
    protected class_3966 method_7434(class_243 p_37575_, class_243 p_37576_) {
        return this.isReturning ? null : super.method_7434(p_37575_, p_37576_);
    }

    protected void method_7454(class_3966 hit_result) {
        float sound_volume;
        class_1297 target = hit_result.method_17782();
        boolean hurt_success = this.hurtDogTridentTarget(target);
        boolean did_lightning = this.maySummonLightningBolt(target);
        this.switchToReturnToDog();
        this.method_18799(class_243.field_1353);
        Object play_sound = null;
        play_sound = did_lightning ? null : (hurt_success ? class_3417.field_15213 : null);
        float f = sound_volume = did_lightning ? 5.0f : 1.0f;
        if (play_sound != null) {
            this.method_5783((class_3414)play_sound, sound_volume, 1.0f);
        }
    }

    private boolean hurtDogTridentTarget(class_1297 target) {
        boolean result;
        float damage = 8.0f;
        class_1297 owner = this.method_24921();
        DogThrownTrident indirect_entity_source = owner == null ? this : owner;
        class_1282 trident_source = this.method_48923().method_48803((class_1665)this, (class_1297)indirect_entity_source);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverlevel = (class_3218)class_19372;
            damage = class_1890.method_60120((class_3218)serverlevel, (class_1799)this.method_59958(), (class_1297)target, (class_1282)trident_source, (float)damage);
        }
        if (this.method_5809()) {
            EntityUtil.setSecondsOnFire(target, 5);
        }
        if (!(result = target.method_64397((class_3218)this.method_37908(), trident_source, damage))) {
            return false;
        }
        this.doDogTridentEnchantDamageEffects(owner, target, trident_source);
        this.killCreeperIfCreeperSweeper(target);
        return true;
    }

    private void doDogTridentEnchantDamageEffects(class_1297 owner, class_1297 target, class_1282 source) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverlevel1 = (class_3218)class_19372;
            class_1890.method_60619((class_3218)serverlevel1, (class_1297)target, (class_1282)source, (class_1799)this.method_59958());
        }
        if (target instanceof class_1309) {
            class_1309 livingentity = (class_1309)target;
            this.method_59957(livingentity, source);
            this.method_7450(livingentity);
        }
    }

    private void killCreeperIfCreeperSweeper(class_1297 target) {
        class_1297 owner = this.method_24921();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel(DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof class_1548)) {
            return;
        }
        class_1548 creeper = (class_1548)target;
        creeper.method_6033(0.0f);
        creeper.method_6078(dog.method_48923().method_48812((class_1309)dog));
    }

    public boolean isChanneling() {
        Optional channel = this.method_56673().method_30530(class_7924.field_41265).method_46746(class_1893.field_9117);
        if (!channel.isPresent()) {
            return false;
        }
        return this.method_54759().method_58657().method_57536((class_6880)channel.get()) > 0;
    }

    private boolean maySummonLightningBolt(class_1297 target) {
        if (!(this.method_37908() instanceof class_3218)) {
            return false;
        }
        if (!this.method_37908().method_8546()) {
            return false;
        }
        if (!this.isChanneling()) {
            return false;
        }
        class_2338 target_b0 = target.method_24515();
        if (!this.method_37908().method_8311(target_b0)) {
            return false;
        }
        class_1538 lightningbolt = (class_1538)class_1299.field_6112.method_5883(this.method_37908(), class_3730.field_16461);
        if (lightningbolt == null) {
            return false;
        }
        lightningbolt.method_29495(class_243.method_24955((class_2382)target_b0));
        lightningbolt.method_6961(null);
        this.method_37908().method_8649((class_1297)lightningbolt);
        return true;
    }

    public static int getDogTridentTimeout() {
        return 50;
    }

    protected boolean method_34713(class_1657 player) {
        return false;
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)class_1802.field_8547);
    }

    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public boolean method_31746() {
        return false;
    }

    protected float method_7436() {
        return 0.99f;
    }

    public boolean method_5727(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public class_1799 method_59958() {
        return this.method_54759();
    }
}

