/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ChangeAccessoriesData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class ChangeAccessoryPacket
extends DogPacket<ChangeAccessoriesData> {
    @Override
    public void encode(ChangeAccessoriesData data, class_2540 buf) {
        buf.method_53002(data.entityId);
        buf.method_52964(data.add);
        buf.method_52964(data.wolfArmorSlot);
        buf.method_53002(data.slotId);
    }

    @Override
    public ChangeAccessoriesData decode(class_2540 buf) {
        int dog_id = buf.readInt();
        boolean add = buf.readBoolean();
        boolean wolf_armor = buf.readBoolean();
        int slot_id = buf.readInt();
        return new ChangeAccessoriesData(dog_id, add, slot_id, wolf_armor);
    }

    @Override
    public void handleDog(Dog dog, ChangeAccessoriesData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        class_3222 sender = ctx.get().getSender();
        if (!dog.canInteract((class_1309)sender)) {
            return;
        }
        if (data.add) {
            class_1661 inventory = sender.method_31548();
            class_2371 items = inventory.method_67533();
            if (data.slotId >= items.size()) {
                return;
            }
            class_1799 item = (class_1799)items.get(data.slotId);
            class_1792 class_17922 = item.method_7909();
            if (class_17922 instanceof AccessoryItem) {
                AccessoryItem accessoryItem = (AccessoryItem)class_17922;
                AccessoryInstance inst = accessoryItem.createInstance(dog, item, (class_1657)sender);
                if (inst == null) {
                    return;
                }
                if (dog.addAccessory(inst)) {
                    dog.consumeItemFromStack((class_1297)dog, item);
                }
            } else if (item.method_7909() == class_1802.field_47831) {
                ChangeAccessoryPacket.handleSetWolfArmor(sender, dog, item);
            }
        } else {
            if (data.wolfArmorSlot) {
                ChangeAccessoryPacket.handleUnsetWolfArmor(sender, dog, data);
                return;
            }
            List<AccessoryInstance> accessories = dog.getAccessories();
            if (data.slotId >= accessories.size()) {
                return;
            }
            AccessoryInstance toRemove = accessories.get(data.slotId);
            if (toRemove == null) {
                return;
            }
            class_1661 inventory = sender.method_31548();
            class_1799 retItem = toRemove.getReturnItem();
            if (retItem == null) {
                return;
            }
            if (inventory.method_7376() < 0) {
                return;
            }
            inventory.method_7394(toRemove.getReturnItem());
            dog.dogSyncedDataManager.accessories().remove(data.slotId);
            dog.dogSyncedDataManager.setAccessoriesDirty();
        }
    }

    private static void handleSetWolfArmor(class_3222 sender, Dog dog, class_1799 toConsume) {
        if (dog.hasWolfArmor()) {
            return;
        }
        if (!toConsume.method_31574(class_1802.field_47831)) {
            return;
        }
        dog.setWolfArmor(toConsume.method_46651(1));
        dog.consumeItemFromStack((class_1297)dog, toConsume);
    }

    private static void handleUnsetWolfArmor(class_3222 sender, Dog dog, ChangeAccessoriesData data) {
        if (!dog.hasWolfArmor()) {
            return;
        }
        class_1661 inventory = sender.method_31548();
        if (inventory.method_7376() < 0) {
            return;
        }
        dog.method_43077(class_3417.field_47722);
        class_1799 wolf_armor0 = dog.wolfArmor();
        dog.setWolfArmor(class_1799.field_8037);
        inventory.method_7394(wolf_armor0.method_46651(1));
    }
}

