/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class RoaringGaleTalent
extends TalentInstance {
    private int cooldown = 0;

    public RoaringGaleTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        super.init(dogIn);
        this.cooldown = dogIn.field_6012;
    }

    public static int getAffectDuration(int level) {
        if (level >= 5) {
            return 70;
        }
        if (level <= 0) {
            return 0;
        }
        switch (level) {
            case 1: {
                return 20;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 36;
            }
            case 4: {
                return 48;
            }
        }
        return 20;
    }

    public static int getKnockback(int level) {
        return level;
    }

    public static int getDamage(int level) {
        return level > 4 ? level * 2 : level;
    }

    public static Optional<Integer> roar(List<Dog> dogsList, class_1937 world, class_1657 player) {
        if (world.field_9236) {
            return Optional.empty();
        }
        List roarDogs = dogsList.stream().filter(dog -> dog.getDogLevel(DoggyTalents.ROARING_GALE) > 0).collect(Collectors.toList());
        if (roarDogs.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"talent.doggytalents.roaring_gale.level"), true);
            return Optional.empty();
        }
        if ((roarDogs = roarDogs.stream().filter(RoaringGaleTalent::isNotOnRoarCooldown).collect(Collectors.toList())).isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"talent.doggytalents.roaring_gale.cooldown"), true);
            return Optional.empty();
        }
        boolean anyHits = false;
        int whistle_cooldown = 0;
        for (Dog dog2 : roarDogs) {
            int level = dog2.getDogLevel(DoggyTalents.ROARING_GALE);
            int damage = RoaringGaleTalent.getDamage(level);
            int effectDuration = RoaringGaleTalent.getAffectDuration(level);
            int knockback = RoaringGaleTalent.getKnockback(level);
            boolean hit = false;
            List targets = dog2.method_37908().method_18467(class_1309.class, dog2.method_5829().method_1009((double)(level * 4), 4.0, (double)(level * 4)));
            for (class_1309 mob : targets) {
                if (!(mob instanceof class_1569)) continue;
                hit = true;
                mob.method_64419(mob.method_48923().method_48830(), (float)damage);
                mob.method_6092(new class_1293(class_1294.field_5909, effectDuration, 127, false, false));
                mob.method_6092(new class_1293(class_1294.field_5912, effectDuration, 1, false, false));
                mob.method_5762((double)(class_3532.method_15374((float)(mob.method_36454() * ((float)Math.PI / 180))) * (float)knockback * 0.5f), 0.1, (double)(-class_3532.method_15362((float)(mob.method_36454() * ((float)Math.PI / 180))) * (float)knockback * 0.5f));
            }
            int cooldown = 0;
            if (hit) {
                dog2.method_5783(EntityUtil_1_21_5.legacyWolfGrowlSound(dog2), 0.7f, 1.0f);
                cooldown = level >= 5 ? 60 : 100;
                anyHits = true;
            } else {
                dog2.method_5783(EntityUtil_1_21_5.legacyWolfAmbientSound(dog2), 1.0f, 1.2f);
                cooldown = level >= 5 ? 30 : 50;
            }
            RoaringGaleTalent.setRoarCooldownFor(dog2, dog2.field_6012 + cooldown);
            if (cooldown <= whistle_cooldown) continue;
            whistle_cooldown = cooldown;
        }
        if (!anyHits) {
            player.method_7353((class_2561)class_2561.method_43471((String)"talent.doggytalents.roaring_gale.miss"), true);
        }
        if (whistle_cooldown <= 0) {
            return Optional.empty();
        }
        return Optional.of(whistle_cooldown);
    }

    private static boolean isNotOnRoarCooldown(Dog dog) {
        Optional<TalentInstance> inst_optional = dog.getTalent(DoggyTalents.ROARING_GALE.get());
        if (!inst_optional.isPresent()) {
            return false;
        }
        TalentInstance inst = inst_optional.get();
        if (!(inst instanceof RoaringGaleTalent)) {
            return false;
        }
        RoaringGaleTalent roar = (RoaringGaleTalent)inst;
        int cooldownDeadline = roar.cooldown;
        return cooldownDeadline <= dog.field_6012;
    }

    private static void setRoarCooldownFor(Dog dog, int val) {
        Optional<TalentInstance> inst_optional = dog.getTalent(DoggyTalents.ROARING_GALE.get());
        if (!inst_optional.isPresent()) {
            return;
        }
        TalentInstance inst = inst_optional.get();
        if (!(inst instanceof RoaringGaleTalent)) {
            return;
        }
        RoaringGaleTalent roar = (RoaringGaleTalent)inst;
        roar.cooldown = val;
    }
}

