/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.backward_imitate.NBTUtil_1_21_7;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.item.ScentTreatItem;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class SnifferDogTalent
extends TalentInstance {
    private class_2248 detectingBlock = class_2246.field_10124;
    private Optional<class_2338> suspiciousPos = Optional.empty();
    private int dontNotifyOwnerAgainTick = 0;
    private int tickTillDetect = 5;

    public SnifferDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
        if (!dogIn.isDoingFine()) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (this.dontNotifyOwnerAgainTick > 0) {
            --this.dontNotifyOwnerAgainTick;
        }
        this.validateSuspiciousPos(dog);
        if (!this.suspiciousPos.isPresent() && !dog.method_6172() && this.detectingBlock != class_2246.field_10124) {
            this.detectBlocksAround(dog);
        }
        if (dog.isBusy()) {
            return;
        }
        if (this.suspiciousPos.isPresent() && this.dontNotifyOwnerAgainTick <= 0) {
            this.notifyOwner(dog);
        }
    }

    private void detectBlocksAround(Dog dog) {
        if (--this.tickTillDetect > 0) {
            return;
        }
        this.tickTillDetect = 10;
        this.doDetectBlockAround(dog);
    }

    private void doDetectBlockAround(Dog dog) {
        class_2338 dog_b0 = dog.method_24515();
        int radius = this.getDetectRadius(dog);
        int start = 0;
        while (start + 2 <= radius) {
            for (int i = 0; i < 10; ++i) {
                class_5819 r = dog.method_59922();
                int offSmall = 2;
                int offLarge = start + 2;
                int r1 = r.method_39332(-offLarge, offLarge);
                int r2 = r.method_39332(-offSmall, offSmall);
                r2 += class_3532.method_17822((double)r2) * start;
                int randXOff = r1;
                int randZOff = r2;
                if (r.method_43056()) {
                    randXOff = r2;
                    randZOff = r1;
                }
                int randYOff = r.method_39332(-3, 3);
                class_2338 rand_b0 = dog_b0.method_10081(new class_2382(randXOff, randYOff, randZOff));
                class_2680 state = dog.method_37908().method_8320(rand_b0);
                if (state.method_26204() != this.detectingBlock) continue;
                this.suspiciousPos = Optional.of(rand_b0);
                return;
            }
            start += 2;
        }
    }

    private int getDetectRadius(Dog dog) {
        if (this.level() >= 5) {
            return 28;
        }
        if (this.level() < 0) {
            return 0;
        }
        switch (this.level()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 22;
            }
        }
        return 8;
    }

    public void setDetectBlock(class_2248 block) {
        this.detectingBlock = block;
        if (block == null || block instanceof class_2189) {
            this.detectingBlock = class_2246.field_10124;
        }
    }

    public void clearDetectBlock() {
        this.detectingBlock = class_2246.field_10124;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dog, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        if (!stack.method_31574(DoggyItems.SCENT_TREAT.get())) {
            return DogInteractionResult.PASS;
        }
        if (dog.method_37908().field_9236) {
            return DogInteractionResult.SUCCESS;
        }
        if (playerIn.method_5715()) {
            if (this.detectingBlock == null) {
                this.detectingBlock = class_2246.field_10124;
            }
            class_5250 c1 = this.detectingBlock == class_2246.field_10124 ? class_2561.method_43471((String)"talent.doggytalents.sniffer_dog.detecting_block_status.none") : class_2561.method_43469((String)"talent.doggytalents.sniffer_dog.detecting_block_status", (Object[])new Object[]{dog.method_5477().getString(), class_2561.method_43471((String)this.detectingBlock.method_8389().method_7876()).method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)))});
            PlayerUtil.sendSystemMessage((class_1309)playerIn, (class_2561)c1);
            return DogInteractionResult.SUCCESS;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (!tag.contains(ScentTreatItem.SCENT_BLOCK_ID)) {
            this.clearDetectBlock();
        } else {
            class_2248 block = (class_2248)NBTUtil.getRegistryValue(tag, ScentTreatItem.SCENT_BLOCK_ID, class_7923.field_41175);
            if (block == null) {
                return DogInteractionResult.SUCCESS;
            }
            this.setDetectBlock(block);
        }
        dog.method_5783(class_3417.field_28397, 1.0f, 1.0f);
        class_1799 retItem = new class_1799((class_1935)DoggyItems.DROOL_SCENT_TREAT.get());
        if (ItemUtil.hasTag(stack)) {
            ItemUtil.copyTag(stack, retItem);
        }
        dog.method_5775((class_3218)dog.method_37908(), retItem);
        stack.method_7934(1);
        return DogInteractionResult.SUCCESS;
    }

    public void validateSuspiciousPos(Dog dog) {
        if (!this.suspiciousPos.isPresent()) {
            return;
        }
        class_2338 pos = this.suspiciousPos.get();
        class_2680 state = dog.method_37908().method_8320(pos);
        if (!state.method_27852(this.detectingBlock)) {
            this.suspiciousPos = Optional.empty();
        }
    }

    public void notifyOwner(Dog dog) {
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return;
        }
        if (owner.method_5858((class_1297)dog) > 64.0) {
            return;
        }
        if (!dog.canDoIdileAnim()) {
            return;
        }
        dog.triggerAction(new DogGetOwnerAttentionAndInformAction(dog, owner, this));
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        if (this.detectingBlock == null) {
            this.detectingBlock = class_2246.field_10124;
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)this.detectingBlock);
        NBTUtil_1_21_7.putResourceLocation(compound, "snifferDog_detectingBlock", id);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        class_2248 block = (class_2248)NBTUtil.getRegistryValue(compound, "snifferDog_detectingBlock", class_7923.field_41175);
        if (block == null) {
            block = class_2246.field_10124;
        }
        this.detectingBlock = block;
    }

    public static class DogGetOwnerAttentionAndInformAction
    extends TriggerableAction {
        private SnifferDogTalent inst;
        private class_1309 owner;
        private boolean isPointingToPos = false;
        private int timeOutTick = 0;
        private boolean notifiedOwner = false;
        private class_2338 targetPos;
        private int tickLookLeft = 0;
        private int tickAnim = 0;
        private DogAnimation currentAnimation = DogAnimation.SNIFFER_DOG_POINT_STRAIGHT;

        public DogGetOwnerAttentionAndInformAction(Dog dog, class_1309 owner, SnifferDogTalent inst) {
            super(dog, false, false);
            this.inst = inst;
            this.owner = owner;
        }

        @Override
        public void onStart() {
            this.isPointingToPos = false;
            this.notifiedOwner = false;
            this.timeOutTick = 400 + this.dog.method_59922().method_43048(6) * 20;
            this.targetPos = this.inst.suspiciousPos.orElse(null);
            this.tickLookLeft = 10;
            this.tickAnim = 0;
        }

        @Override
        public void tick() {
            if (!this.owner.method_5805() || this.owner.method_7325()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.owner.method_5858((class_1297)this.dog) > 144.0) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.invalidateTargetPos();
            if (this.targetPos == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.isPointingToPos) {
                --this.timeOutTick;
                if (this.timeOutTick <= 0) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            } else {
                boolean anim_end_or_interupted;
                boolean bl = anim_end_or_interupted = this.tickAnim >= this.currentAnimation.getLengthTicks() || this.dog.getAnim() != this.currentAnimation || !this.dog.method_24828();
                if (this.tickLookLeft <= 0 && anim_end_or_interupted) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            }
            if (this.isPointingToPos) {
                this.pointsTowardThePos();
            } else {
                this.getOwnerAttention();
            }
        }

        private void invalidateTargetPos() {
            if (this.targetPos == null) {
                return;
            }
            if (!this.inst.suspiciousPos.isPresent()) {
                this.targetPos = null;
                return;
            }
            if (!this.inst.suspiciousPos.get().equals((Object)this.targetPos)) {
                this.targetPos = null;
                return;
            }
        }

        private void getOwnerAttention() {
            if (this.targetPos == null) {
                return;
            }
            this.dog.method_5988().method_35111((class_1297)this.owner);
            if (!this.notifiedOwner) {
                this.notifiedOwner = true;
                this.notifyOwner(this.dog, this.owner, this.dog.method_5707(class_243.method_24953((class_2382)this.targetPos)));
                this.moveBackIfNeeded(this.dog, this.targetPos);
            }
            if (this.dog.method_5858((class_1297)this.owner) > 16.0) {
                return;
            }
            if (!this.checkIfCanSeeOwner(this.dog, this.owner)) {
                return;
            }
            if (DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
                this.isPointingToPos = true;
            }
        }

        private void pointsTowardThePos() {
            if (this.targetPos == null) {
                return;
            }
            this.dog.method_5988().method_19615(class_243.method_24953((class_2382)this.targetPos));
            if (this.tickLookLeft > 0) {
                --this.tickLookLeft;
                if (this.tickLookLeft <= 0) {
                    this.currentAnimation = this.pickAnim(this.dog, this.targetPos);
                    this.dog.setAnim(this.currentAnimation);
                }
                return;
            }
            ++this.tickAnim;
        }

        private void moveBackIfNeeded(Dog dog, class_2338 pos) {
            class_243 v_dog_pos = class_243.method_24955((class_2382)pos).method_1020(dog.method_19538());
            class_243 v_dog_pos_xz = new class_243(v_dog_pos.field_1352, 0.0, v_dog_pos.field_1350).method_1029();
            class_243 wantedStandPos = class_243.method_24955((class_2382)dog.method_24515()).method_1020(v_dog_pos_xz.method_1021(0.5));
            dog.method_5962().method_6239(wantedStandPos.field_1352, wantedStandPos.field_1351, wantedStandPos.field_1350, 0.5);
        }

        private DogAnimation pickAnim(Dog dog, class_2338 pos) {
            class_243 v_dog_pos = class_243.method_24953((class_2382)pos).method_1020(dog.method_33571());
            if (v_dog_pos.field_1351 < -1.0) {
                return DogAnimation.SNIFFER_DOG_POINT_DOWNARD;
            }
            if (v_dog_pos.field_1351 > 1.0) {
                return DogAnimation.SNIFFER_DOG_POINT_UPWARD;
            }
            return DogAnimation.SNIFFER_DOG_POINT_STRAIGHT;
        }

        private void notifyOwner(Dog dog, class_1309 owner, double distanceAwaySqr) {
            class_5250 c1 = class_2561.method_43469((String)this.getStringStatus(dog, distanceAwaySqr), (Object[])new Object[]{dog.method_5477().getString()});
            PlayerUtil.sendSystemMessage(owner, (class_2561)c1);
            if (distanceAwaySqr <= 64.0) {
                class_3414 sound = dog.dogMood.getSnifferDogForteSound();
                dog.method_5783(sound, 1.0f, 1.0f);
            } else {
                class_3414 sound = dog.dogMood.getSnifferDogPianoSound();
                dog.method_5783(sound, 1.0f, 1.5f);
            }
        }

        private String getStringStatus(Dog dog, double distanceAwaySqr) {
            int r = dog.method_59922().method_43048(3);
            String posfix = ".mid";
            if (distanceAwaySqr > 256.0) {
                posfix = ".far";
            } else if (distanceAwaySqr <= 64.0) {
                posfix = ".near";
            }
            return "talent.doggytalents.sniffer_dog.notify_owner." + r + posfix;
        }

        private boolean checkIfCanSeeOwner(Dog dog, class_1309 owner) {
            if (dog.field_6012 % 5 != 0) {
                return false;
            }
            return dog.method_5985().method_6369((class_1297)owner);
        }

        @Override
        public void onStop() {
            this.inst.suspiciousPos = Optional.empty();
            this.inst.dontNotifyOwnerAgainTick = (5 + this.dog.method_59922().method_43048(10)) * 20;
        }
    }
}

