/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.tool_actions.DogBridgingAction;
import doggytalents.common.util.PlayerUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.apache.commons.lang3.tuple.Pair;

public class DogBridging {
    public static Optional<Pair<class_1799, class_1747>> getBridgingMaterial(DoggyToolsTalent inst, Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(inst.level()); ++i) {
            class_1792 class_17922;
            class_1799 stack = inst.getTools().getStackInSlot(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1747)) continue;
            class_1747 block_item = (class_1747)class_17922;
            return Optional.of(Pair.of((Object)stack, (Object)block_item));
        }
        return Optional.empty();
    }

    public static boolean isValidBridgingDog(DoggyToolsTalent inst, Dog dog) {
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BRIDGING.get()).booleanValue()) {
            return false;
        }
        if (inst.level() < inst.getTalent().getMaxLevel()) {
            return false;
        }
        Optional<Pair<class_1799, class_1747>> pair = DogBridging.getBridgingMaterial(inst, dog);
        return pair.isPresent();
    }

    public static boolean isValidBridgingDog(Dog dog) {
        Optional<DoggyToolsTalent> inst = dog.getTalent(DoggyTalents.DOGGY_TOOLS.get(), DoggyToolsTalent.class);
        if (!inst.isPresent()) {
            return false;
        }
        return DogBridging.isValidBridgingDog(inst.get(), dog);
    }

    public static void equipBridgingStack(DoggyToolsTalent inst, Dog dog) {
        Optional<Pair<class_1799, class_1747>> pair = DogBridging.getBridgingMaterial(inst, dog);
        if (!pair.isPresent()) {
            return;
        }
        dog.method_6122(class_1268.field_5808, (class_1799)pair.get().getLeft());
    }

    public static Optional<Pair<Dog, DoggyToolsTalent>> getNearestBridgingDog(class_1657 player, class_1937 level) {
        List valid_dogs = level.method_8390(Dog.class, player.method_5829().method_1009(7.0, 2.0, 7.0), d -> {
            if (!d.isDoingFine()) {
                return false;
            }
            if (d.isBusy()) {
                return false;
            }
            if (d.method_24345()) {
                return false;
            }
            return DogBridging.isValidBridgingDog(d);
        });
        if (valid_dogs.isEmpty()) {
            return Optional.empty();
        }
        double min_dist = ((Dog)valid_dogs.get(0)).method_5858((class_1297)player);
        Dog choosen_dog = (Dog)valid_dogs.get(0);
        for (Dog dog : valid_dogs) {
            double dist = dog.method_5858((class_1297)player);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            choosen_dog = dog;
        }
        Optional<DoggyToolsTalent> inst = choosen_dog.getTalent(DoggyTalents.DOGGY_TOOLS.get(), DoggyToolsTalent.class);
        if (!inst.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)choosen_dog, (Object)inst.get()));
    }

    public static Optional<Integer> getBridgingLimit() {
        int limit = (Integer)ConfigHandler.SERVER.DOGGY_TOOLS_BRIDGING_LIMIT.get();
        if (limit <= 0) {
            return Optional.empty();
        }
        return Optional.of(limit);
    }

    public static boolean checkIfReachedBridgingLimit(class_1657 player) {
        Optional<Integer> limit_optional = DogBridging.getBridgingLimit();
        if (!limit_optional.isPresent()) {
            return false;
        }
        int limit = limit_optional.get();
        DogLocationStorage storage = DogLocationStorage.get(player.method_5682());
        int current_count = storage.bridgingDogLimitMap.getOrDefault(player.method_5667(), 0);
        return current_count >= limit;
    }

    public static void incBridgingCount(class_1309 player) {
        DogLocationStorage storage = DogLocationStorage.get(player.method_5682());
        storage.bridgingDogLimitMap.compute(player.method_5667(), (uuid, old_val) -> {
            if (old_val == null) {
                return 1;
            }
            return old_val + 1;
        });
    }

    public static void decBridgingCount(class_1309 player) {
        DogLocationStorage storage = DogLocationStorage.get(player.method_5682());
        storage.bridgingDogLimitMap.computeIfPresent(player.method_5667(), (uuid, old_val) -> {
            if (old_val == null) {
                return null;
            }
            int new_val = old_val - 1;
            if (new_val <= 0) {
                return null;
            }
            return new_val;
        });
    }

    public static void useBridgingWhistle(WhistleItem item, class_1657 owner, class_1937 level) {
        if (level.field_9236) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BRIDGING.get()).booleanValue()) {
            return;
        }
        if (DogBridging.checkIfReachedBridgingLimit(owner)) {
            PlayerUtil.sendSystemMessage((class_1309)owner, (class_2561)class_2561.method_43469((String)"dogcommand.bridging.limit_exceeded", (Object[])new Object[]{DogBridging.getBridgingLimit().orElse(0)}).method_27692(class_124.field_1061));
            PlayerUtil.addCooldown(owner, item, 20);
            return;
        }
        Optional<Pair<Dog, DoggyToolsTalent>> pair_optional = DogBridging.getNearestBridgingDog(owner, level);
        if (!pair_optional.isPresent()) {
            return;
        }
        Pair<Dog, DoggyToolsTalent> pair = pair_optional.get();
        Dog dog = (Dog)pair.getLeft();
        DoggyToolsTalent inst = (DoggyToolsTalent)pair.getRight();
        DogBridgingAction action = new DogBridgingAction(dog, (class_1309)owner, owner.method_5791(), owner.method_24515(), inst);
        if (dog.triggerAction(action)) {
            DogBridging.incBridgingCount((class_1309)owner);
        }
        PlayerUtil.sendSystemMessage((class_1309)owner, (class_2561)class_2561.method_43469((String)"dogcommand.bridging", (Object[])new Object[]{dog.method_5477().getString()}));
        PlayerUtil.addCooldown(owner, item, 20);
    }

    public static void onBridgingActionStop(class_1309 owner) {
        DogBridging.decBridgingCount(owner);
    }
}

