/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class DogGreedyFireSafeSearchPath
extends class_11 {
    private ArrayList<class_9> nodes;
    private Dog dog;
    public boolean finished;
    private int maxLength;
    private class_9 startNode;
    private int walkableCount = 0;

    private DogGreedyFireSafeSearchPath(Dog dog, ArrayList<class_9> nodes, int maxLength) {
        super(nodes, dog.method_24515(), false);
        this.nodes = nodes;
        this.dog = dog;
        this.maxLength = maxLength;
    }

    public static DogGreedyFireSafeSearchPath create(Dog dog, int maxLength) {
        Optional<class_9> start_node = DogGreedyFireSafeSearchPath.getStartNode(dog);
        if (!start_node.isPresent()) {
            return null;
        }
        ArrayList<class_9> initNodes = new ArrayList<class_9>(maxLength);
        initNodes.add(start_node.get());
        DogGreedyFireSafeSearchPath ret = new DogGreedyFireSafeSearchPath(dog, initNodes, maxLength);
        ret.startNode = start_node.get();
        Optional<class_9> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(ret);
        if (!node_optional.isPresent()) {
            return null;
        }
        initNodes.clear();
        initNodes.add(node_optional.get());
        return ret;
    }

    private static Optional<class_9> getStartNode(Dog dog) {
        class_2338 dog_b0 = class_2338.method_49638((class_2374)DogPathNavigation.getTempDogPos(dog));
        if (DogGreedyFireSafeSearchPath.isValidStart(dog, dog_b0)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(dog_b0);
        }
        class_238 dog_bb = dog.method_5829();
        int min_x = class_3532.method_15357((double)dog_bb.field_1323);
        int min_z = class_3532.method_15357((double)dog_bb.field_1321);
        int max_x = class_3532.method_15357((double)dog_bb.field_1320);
        int max_z = class_3532.method_15357((double)dog_bb.field_1324);
        for (int i = min_x; i <= max_x; ++i) {
            for (int j = min_z; j <= max_z; ++j) {
                class_2338 check_b0 = new class_2338(i, dog_b0.method_10264(), j);
                if (!DogGreedyFireSafeSearchPath.isValidStart(dog, check_b0)) continue;
                return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(check_b0);
            }
        }
        return Optional.empty();
    }

    private static boolean isValidStart(Dog dog, class_2338 pos) {
        class_2338 pos_below = pos.method_10074();
        class_2680 state_below = dog.method_37908().method_8320(pos_below);
        return state_below.method_26234((class_1922)dog.method_37908(), pos_below) || DogNodeEvaluator.dogGetPathTypeFromState((class_1922)dog.method_37908(), pos_below) == class_7.field_22;
    }

    private static Optional<class_9> blockPosToNodeOptional(class_2338 pos) {
        return Optional.of(new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public void method_44() {
        super.method_44();
        if (this.finished) {
            return;
        }
        boolean append_result = this.tryAppendPath();
        if (!append_result) {
            this.finished = true;
        }
    }

    public int getWalkableCount() {
        return this.walkableCount;
    }

    public boolean method_46() {
        if (this.finished) {
            return true;
        }
        return this.method_39() >= this.nodes.size();
    }

    public boolean tryAppendPath() {
        if (this.method_39() >= this.maxLength) {
            return false;
        }
        if (this.nodes.isEmpty()) {
            return false;
        }
        class_9 old_end = this.nodes.get(this.nodes.size() - 1);
        Optional<class_9> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(this);
        if (!node_optional.isPresent()) {
            return false;
        }
        class_9 node = node_optional.get();
        if (node.field_41 != class_7.field_12 && this.walkableCount > 0) {
            return false;
        }
        this.nodes.add(node);
        if (node.field_41 == class_7.field_12) {
            ++this.walkableCount;
        }
        if (old_end.field_39 == node.field_39) {
            node.field_41 = class_7.field_12;
        }
        return true;
    }

    private boolean containNode(class_9 node) {
        for (class_9 node1 : this.nodes) {
            if (!node1.equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    private static Optional<class_9> scanSurroundingForNextPos(DogGreedyFireSafeSearchPath path) {
        float malus;
        boolean is_last_resort;
        boolean clear_walkable;
        int j;
        int i;
        if (path.nodes.isEmpty()) {
            return Optional.empty();
        }
        class_2338 b0 = path.nodes.get(path.nodes.size() - 1).method_22879();
        float malus_min = Float.MAX_VALUE;
        class_9 node_chosen = null;
        boolean[] BLOCKED_0_Z = new boolean[2];
        boolean[] BLOCKED_X_0 = new boolean[2];
        class_7 pathtype_above = class_14.method_57625((class_1308)path.dog, (class_2338)b0.method_10084());
        class_9 last_resort = null;
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean is_diagonally_block;
                if (i == 0 && j == 0 || i * j != 0) continue;
                class_9 node = DogGreedyFireSafeSearchPath.findDogNode(path.dog, b0.method_10069(i, 0, j));
                boolean require_jump = node.field_39 > b0.method_10264();
                boolean bl = is_diagonally_block = path.dog.method_5944(node.field_41) < 0.0f || require_jump;
                if (is_diagonally_block) {
                    if (i != 0) {
                        BLOCKED_X_0[i > 0 ? 1 : 0] = true;
                    } else {
                        BLOCKED_0_Z[j > 0 ? 1 : 0] = true;
                    }
                }
                if (!DogGreedyFireSafeSearchPath.canAddNodeToPath(path, node) || require_jump && pathtype_above == class_7.field_22) continue;
                boolean bl2 = clear_walkable = node.field_41 == class_7.field_12 && (!require_jump || pathtype_above == class_7.field_7);
                if (clear_walkable) {
                    return Optional.of(node);
                }
                boolean bl3 = is_last_resort = require_jump && pathtype_above != class_7.field_22;
                if (is_last_resort) {
                    last_resort = node;
                }
                malus = path.dog.method_5944(node.field_41);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean require_jump;
                boolean diagonal_blocked;
                if (i == 0 && j == 0 || i * j == 0) continue;
                boolean bl = BLOCKED_0_Z[j > 0 ? 1 : 0] && BLOCKED_X_0[i > 0 ? 1 : 0] ? true : (diagonal_blocked = false);
                if (diagonal_blocked) continue;
                class_9 node = DogGreedyFireSafeSearchPath.findDogNode(path.dog, b0.method_10069(i, 0, j));
                boolean bl4 = require_jump = node.field_39 > b0.method_10264();
                if (!DogGreedyFireSafeSearchPath.canAddNodeToPath(path, node) || require_jump && pathtype_above == class_7.field_22) continue;
                boolean bl5 = clear_walkable = node.field_41 == class_7.field_12 && (!require_jump || pathtype_above == class_7.field_7);
                if (clear_walkable) {
                    return Optional.of(node);
                }
                boolean bl6 = is_last_resort = require_jump && pathtype_above != class_7.field_22;
                if (is_last_resort) {
                    last_resort = node;
                }
                malus = path.dog.method_5944(node.field_41);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        if (node_chosen != null) {
            return Optional.of(node_chosen);
        }
        if (last_resort != null) {
            return Optional.of(last_resort);
        }
        return Optional.empty();
    }

    private static class_9 findDogNode(Dog dog, class_2338 pos) {
        class_2338.class_2339 b1 = pos.method_25503();
        class_7 b1_type = class_14.method_57625((class_1308)dog, (class_2338)b1.method_25503());
        int offsetY = 0;
        if (b1_type == class_7.field_22) {
            offsetY = 1;
        } else if (b1_type == class_7.field_7) {
            offsetY = -1;
        }
        if (offsetY != 0) {
            b1.method_10100(0, offsetY, 0);
            b1_type = class_14.method_57625((class_1308)dog, (class_2338)b1.method_25503());
        }
        class_9 ret_node = new class_9(b1.method_10263(), b1.method_10264(), b1.method_10260());
        ret_node.field_41 = b1_type;
        return ret_node;
    }

    private static boolean canAddNodeToPath(DogGreedyFireSafeSearchPath path, class_9 node) {
        boolean already_in_path;
        boolean bl = already_in_path = path.containNode(node) || path.startNode.equals((Object)node);
        if (already_in_path) {
            return false;
        }
        if (node.field_41 == class_7.field_7) {
            return false;
        }
        return !(path.dog.method_5944(node.field_41) < 0.0f);
    }
}

