/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.inferface;

import com.google.common.base.Function;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.DogGender;
import doggytalents.api.feature.DogMode;
import doggytalents.api.feature.IDog;
import doggytalents.api.inferface.DogArmorItemHandler;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractDog
extends TamableAnimal
implements IDog {
    protected AbstractDog(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
    }

    public void setAttributeModifier(Holder<Attribute> attribute, ResourceLocation modifierLoc, BiFunction<AbstractDog, ResourceLocation, AttributeModifier> modifierGenerator) {
        AttributeModifier newModifier;
        AttributeInstance attributeInst = this.getAttribute(attribute);
        AttributeModifier currentModifier = attributeInst.getModifier(modifierLoc);
        if (currentModifier != null) {
            attributeInst.removeModifier(modifierLoc);
        }
        if ((newModifier = modifierGenerator.apply(this, modifierLoc)) != null) {
            attributeInst.addTransientModifier(newModifier);
        }
    }

    public void removeAttributeModifier(Holder<Attribute> attribute, ResourceLocation modifierLoc) {
        AttributeInstance attrib = this.getAttribute(attribute);
        if (attrib == null) {
            return;
        }
        attrib.removeModifier(modifierLoc);
    }

    @Override
    public AbstractDog getDog() {
        return this;
    }

    public float getSoundVolume() {
        return super.getSoundVolume();
    }

    public void spawnTamingParticles(boolean play) {
        super.spawnTamingParticles(play);
    }

    public void consumeItemFromStack(@Nullable Entity entity, ItemStack stack) {
        if (entity instanceof Player) {
            super.usePlayerItem((Player)entity, InteractionHand.MAIN_HAND, stack);
        } else {
            stack.shrink(1);
        }
    }

    public abstract Component getTranslationKey(Function<DogGender, String> var1);

    public Component getGenderPronoun() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedPronoun));
    }

    public Component getGenderSubject() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedSubject));
    }

    public Component getGenderPossessiveAdj() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedPossessiveAdj));
    }

    public Component getGenderTitle() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedTitle));
    }

    public Component getGenderTip() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedTip));
    }

    public Component getGenderName() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedName));
    }

    public void setNavigation(PathNavigation p) {
        if (p == null) {
            p = this.getDefaultNavigation();
        }
        if (this.navigation == p) {
            return;
        }
        this.navigation.stop();
        this.navigation = p;
    }

    public void setMoveControl(MoveControl m) {
        if (m == null) {
            m = this.getDefaultMoveControl();
        }
        this.breakMoveControl();
        this.moveControl = m;
    }

    public void breakMoveControl() {
        this.moveControl.setWantedPosition(this.getX(), this.getY(), this.getZ(), 1.0);
        this.moveControl.tick();
        this.setJumping(false);
        this.setSpeed(0.0f);
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setZza(0.0f);
    }

    public abstract void resetNavigation();

    public abstract void resetMoveControl();

    public abstract MoveControl getDefaultMoveControl();

    public abstract PathNavigation getDefaultNavigation();

    public abstract boolean canSwimUnderwater();

    public abstract void setDogSwimming(boolean var1);

    public abstract void setDogFlying(boolean var1);

    public abstract boolean isDogFlying();

    public abstract float getClientAnimatedYBodyRotInRadians();

    public abstract float getDogVisualBbHeight();

    public abstract float getDogVisualBbWidth();

    public abstract DogArmorItemHandler dogArmors();

    public abstract ItemStack wolfArmor();

    public abstract boolean canDogWearArmor();

    public abstract boolean canDogUseTools();

    public abstract DogAnimation getAnim();

    public abstract boolean forcedWhenNoneAnim();

    public abstract boolean isDogVariantRenderEffective();

    protected void hurtArmor(DamageSource p_36251_, float p_36252_) {
        this.doHurtEquipment(p_36251_, p_36252_, new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD});
    }

    protected void hurtHelmet(DamageSource p_150103_, float p_150104_) {
        this.doHurtEquipment(p_150103_, p_150104_, new EquipmentSlot[]{EquipmentSlot.HEAD});
    }

    @Override
    public boolean isDefeated() {
        return this.getMode() == DogMode.INJURED;
    }

    public boolean isDoingFine() {
        return this.isAlive() && !this.isDefeated();
    }

    public boolean isDogLowHealth() {
        return false;
    }

    public boolean canStillEat() {
        return false;
    }

    public abstract void setOwnerUUID(UUID var1);

    @Nullable
    public abstract UUID getOwnerUUID();
}

