/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.client.backward_imitate.EntityRenderer_21_3;
import doggytalents.common.entity.misc.DogFoodProjectile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionfc;

public class DogFoodProjectileRenderer
extends EntityRenderer_21_3<DogFoodProjectile> {
    private ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private ItemStack placeholder = new ItemStack((ItemLike)Items.SNOWBALL);

    public DogFoodProjectileRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    public void render(DogFoodProjectile dogFood, float yRot, float pTick, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        stack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        ItemStack foodStack = dogFood.getDogFoodStack();
        if (foodStack.isEmpty()) {
            foodStack = this.placeholder;
        }
        this.itemRenderer.renderStatic(foodStack, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, stack, buffer, null, dogFood.getId());
        stack.popPose();
    }

    @Override
    public ResourceLocation getTextureLocation(DogFoodProjectile proj) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

