/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyItems;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.common.block.RiceMillBlock;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class RiceMillBlockEntity
extends BlockEntity {
    public static final int TOTOAL_SLOTS = 3;
    public static final int[] GRAIN_SLOTS = new int[]{0};
    public static final int BOWL_SLOT = 1;
    public static final int[] INPUT_SLOT = new int[]{0, 1};
    public static final int[] OUTPUT_SLOT = new int[]{2};
    private RiceMillContainer container = new RiceMillContainer(this);
    private InvWrapper containerWrapper = new InvWrapper((Container)this.container);
    public static final int TOTOAL_DATA_SLOT = 2;
    public static final int GRINDING_TIME_ID = 0;
    public static final int GRINDING_TINE_FINISH_ID = 1;
    private int grindingTime;
    private int grindingTimeWhenFinish = 50;
    private RiceMillSyncedData syncedData = new RiceMillSyncedData(this);
    private RiceMillMenuProvider menuProvider = new RiceMillMenuProvider(this);
    public static final int GRIND_ANIM_TICK_LEN = 200;
    private int animationTick = 0;
    private boolean isSpinning = false;
    private MillRecipe currentRecipe = MillRecipe.EMPTY;
    private ItemStack prevInputStack = ItemStack.EMPTY;
    private boolean prevHasBowl = false;
    private static final ArrayList<MillRecipe> MILL_RECIPES = new ArrayList();
    private int tickTillUpdateWaterSource = 20;
    private int tickTillUpdateEject = 8;

    public static void initGrindMap() {
        MILL_RECIPES.clear();
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_GRAINS.get(), 3).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_GRAINS.get(), 1).withOutput(DoggyItems.UNCOOKED_RICE.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_WHEAT.get(), 1).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_WHEAT.get(), 1).withOutput(DoggyItems.UNCOOKED_RICE.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.UNCOOKED_RICE.get(), 3).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_BEANS_DRIED.get(), 3).needsBowl().withOutput(DoggyItems.SOY_MILK.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS_DRIED.get(), 1).needsBowl().withOutput(DoggyItems.SOY_MILK.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS.get(), 1).withOutput(DoggyItems.SOY_BEANS.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS_DRIED.get(), 1).withOutput(DoggyItems.SOY_BEANS_DRIED.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.EDAMAME.get(), 1).withOutput(DoggyItems.EDAMAME_UNPODDED.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(Items.WHEAT, 1).withOutput(Items.BREAD, 1).build());
    }

    public RiceMillBlockEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.RICE_MILL.get(), pos, blockState);
    }

    public static void openContainer(ServerPlayer player, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        player.openMenu((MenuProvider)mill.menuProvider, mill.getBlockPos());
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        RiceMillBlockEntity.updateSpinning(level, mill);
        RiceMillBlockEntity.updateAnimation(mill);
        RiceMillBlockEntity.grindTick(level, pos, blockState, mill);
        RiceMillBlockEntity.ejectTick(level, mill);
    }

    private static void updateSpinning(Level level, RiceMillBlockEntity mill) {
        if (--mill.tickTillUpdateWaterSource > 0) {
            return;
        }
        mill.tickTillUpdateWaterSource = 20;
        mill.isSpinning = RiceMillBlockEntity.scanIfMillCanSpin(level, mill);
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    private static void updateAnimation(RiceMillBlockEntity mill) {
        if (mill.isSpinning) {
            ++mill.animationTick;
        }
        if (mill.animationTick >= 200) {
            mill.animationTick = 0;
        }
    }

    private static boolean scanIfMillCanSpin(Level level, RiceMillBlockEntity mill) {
        BlockPos pos = mill.getBlockPos();
        BlockState state = mill.getBlockState();
        Direction facing = RiceMillBlock.getFacing(state);
        Direction.Axis side_axis = facing.getClockWise().getAxis();
        for (int i = 0; i < 3; ++i) {
            BlockPos middle_pos;
            BlockState middle_state;
            boolean waterPart = i <= 0;
            if (!RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, middle_state = level.getBlockState(middle_pos = pos.offset(facing.getStepX(), i - 1, facing.getStepZ())))) {
                return false;
            }
            BlockPos side_pos_1 = null;
            BlockPos side_pos_2 = null;
            if (side_axis == Direction.Axis.X) {
                side_pos_1 = middle_pos.offset(1, 0, 0);
                side_pos_2 = middle_pos.offset(-1, 0, 0);
            } else {
                side_pos_1 = middle_pos.offset(0, 0, 1);
                side_pos_2 = middle_pos.offset(0, 0, -1);
            }
            BlockState side_state_1 = level.getBlockState(side_pos_1);
            if (!RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, side_state_1)) {
                return false;
            }
            BlockState side_state_2 = level.getBlockState(side_pos_2);
            if (RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, side_state_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBlockForSpiningInPart(boolean waterPart, BlockState state) {
        if (waterPart) {
            return state.is(Blocks.WATER);
        }
        return state.isAir();
    }

    private static void grindTick(Level level, BlockPos pos, BlockState blockState, RiceMillBlockEntity mill) {
        if (level.isClientSide) {
            return;
        }
        ItemStack inputStack = mill.container.getItem(INPUT_SLOT[0]);
        RiceMillBlockEntity.recipeUpdateTick(mill, inputStack);
        MillRecipe currentRecipe = mill.currentRecipe;
        if (RiceMillBlockEntity.isGrinding(mill, inputStack, currentRecipe)) {
            ++mill.grindingTime;
            if (mill.grindingTime >= mill.grindingTimeWhenFinish) {
                RiceMillBlockEntity.createFinishProduct(mill, inputStack, currentRecipe);
                mill.grindingTime = 0;
            }
        } else {
            mill.grindingTime = 0;
        }
    }

    private static void recipeUpdateTick(RiceMillBlockEntity mill, ItemStack currentInputStack) {
        ItemStack bowlStack = mill.container.getItem(1);
        boolean hasBowl = bowlStack.is(Items.BOWL);
        boolean changed = RiceMillBlockEntity.checkAndDetectChangeInMillInput(mill, currentInputStack, hasBowl);
        if (changed) {
            RiceMillBlockEntity.changeRecipeIfNeeded(mill, currentInputStack, hasBowl);
        }
    }

    private static void changeRecipeIfNeeded(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        if (currentInputStack.isEmpty()) {
            return;
        }
        if (RiceMillBlockEntity.currentRecipeStillMatch(mill, currentInputStack, hasBowl)) {
            return;
        }
        mill.currentRecipe = RiceMillBlockEntity.findMillRecipe(currentInputStack, hasBowl);
    }

    private static boolean currentRecipeStillMatch(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        MillRecipe currentRecipe = mill.currentRecipe;
        if (currentRecipe.empty()) {
            return false;
        }
        boolean isMatch = currentRecipe.matches(currentInputStack, hasBowl);
        return isMatch;
    }

    private static boolean checkAndDetectChangeInMillInput(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        if (!RiceMillBlockEntity.isChanged(mill, currentInputStack, hasBowl)) {
            return false;
        }
        mill.prevHasBowl = hasBowl;
        mill.prevInputStack = currentInputStack.isEmpty() ? ItemStack.EMPTY : currentInputStack.copy();
        return true;
    }

    private static boolean isChanged(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        if (currentInputStack.isEmpty() && mill.prevInputStack.isEmpty()) {
            return false;
        }
        if (currentInputStack.isEmpty() != mill.prevInputStack.isEmpty()) {
            return true;
        }
        if (currentInputStack.getItem() != mill.prevInputStack.getItem()) {
            return true;
        }
        if (currentInputStack.getCount() != mill.prevInputStack.getCount()) {
            return true;
        }
        return mill.prevHasBowl != hasBowl;
    }

    private static MillRecipe findMillRecipe(ItemStack stack, boolean hasBowl) {
        if (stack.isEmpty()) {
            return MillRecipe.EMPTY;
        }
        for (MillRecipe recipe : MILL_RECIPES) {
            if (!recipe.matches(stack, hasBowl)) continue;
            return recipe;
        }
        return MillRecipe.EMPTY;
    }

    private static boolean isGrinding(RiceMillBlockEntity mill, ItemStack inputStack, MillRecipe currentRecipe) {
        if (currentRecipe.empty()) {
            return false;
        }
        return mill.isSpinning && RiceMillBlockEntity.hasEnoughIngredient(mill, inputStack, currentRecipe) && RiceMillBlockEntity.productSlotIsAvailable(mill, currentRecipe);
    }

    private static boolean productSlotIsAvailable(RiceMillBlockEntity mill, MillRecipe recipe) {
        if (recipe.empty()) {
            return false;
        }
        ItemStack currentOutputStack = mill.container.getItem(OUTPUT_SLOT[0]);
        if (currentOutputStack.isEmpty()) {
            return true;
        }
        Item outputItemFromInput = recipe.outputItem();
        if (outputItemFromInput == null) {
            return false;
        }
        if (!currentOutputStack.is(outputItemFromInput)) {
            return false;
        }
        return currentOutputStack.getCount() + recipe.outputAmount() <= InventoryUtil.maxStackSizeWithContainer((Container)mill.container, OUTPUT_SLOT[0], currentOutputStack);
    }

    private static boolean hasEnoughIngredient(RiceMillBlockEntity mill, ItemStack inputStack, MillRecipe recipe) {
        if (recipe.empty()) {
            return false;
        }
        ItemStack bowSlotStack = mill.container.getItem(1);
        if (recipe.needBowl() && !bowSlotStack.is(Items.BOWL)) {
            return false;
        }
        int requireGrainLeft = recipe.inputAmount();
        Item inputItem = inputStack.getItem();
        for (int grainSlot : GRAIN_SLOTS) {
            if (requireGrainLeft < 0) break;
            ItemStack grainSlotStack = mill.container.getItem(grainSlot);
            if (!grainSlotStack.is(inputItem)) continue;
            requireGrainLeft -= grainSlotStack.getCount();
        }
        return requireGrainLeft <= 0;
    }

    private static void createFinishProduct(RiceMillBlockEntity mill, ItemStack currentInput, MillRecipe currentRecipe) {
        ItemStack resultStack;
        if (!RiceMillBlockEntity.isGrinding(mill, currentInput, currentRecipe)) {
            return;
        }
        Item inputItem = currentInput.getItem();
        if (currentRecipe.empty()) {
            return;
        }
        ItemStack bowSlotStack = mill.container.getItem(1);
        if (currentRecipe.needBowl() && bowSlotStack.is(Items.BOWL)) {
            bowSlotStack = bowSlotStack.copy();
            bowSlotStack.shrink(1);
            mill.container.setItem(1, bowSlotStack);
        }
        int grainsNeeded = currentRecipe.inputAmount();
        for (int grainSlot : GRAIN_SLOTS) {
            if (grainsNeeded <= 0) break;
            ItemStack grainSlotStack = mill.container.getItem(grainSlot);
            if (!grainSlotStack.is(inputItem)) continue;
            int stackCount = (grainSlotStack = grainSlotStack.copy()).getCount();
            if (stackCount <= grainsNeeded) {
                grainsNeeded -= stackCount;
                grainSlotStack = ItemStack.EMPTY;
            } else {
                grainSlotStack.shrink(grainsNeeded);
                grainsNeeded = 0;
            }
            mill.container.setItem(grainSlot, grainSlotStack);
        }
        if ((resultStack = currentRecipe.produce()) == ItemStack.EMPTY) {
            return;
        }
        mill.containerWrapper.insertItem(OUTPUT_SLOT[0], resultStack, false);
    }

    private boolean isInputMaterialForSlotId(ItemStack stack, int slotId) {
        if (slotId == 1) {
            return stack.is(Items.BOWL);
        }
        return RiceMillBlockEntity.isInputSlotValid(stack);
    }

    public static boolean isInputSlotValid(ItemStack stack) {
        return !stack.is(Items.BOWL);
    }

    private static void ejectTick(Level level, RiceMillBlockEntity mill) {
        if (level.isClientSide) {
            return;
        }
        if (--mill.tickTillUpdateEject > 0) {
            return;
        }
        mill.tickTillUpdateEject = 8;
        ItemStack output = mill.container.getItem(OUTPUT_SLOT[0]);
        if (output.isEmpty()) {
            return;
        }
        Optional<BlockEntity> recipentOptional = RiceMillBlockEntity.getAttachedRecipent(mill);
        if (!recipentOptional.isPresent()) {
            return;
        }
        BlockEntity recipent = recipentOptional.get();
        ItemStack remaining = RiceMillBlockEntity.tryEjectToRecipent(recipent, output);
        if (remaining != output) {
            mill.container.setItem(OUTPUT_SLOT[0], remaining);
        }
    }

    private static Optional<BlockEntity> getAttachedRecipent(RiceMillBlockEntity mill) {
        BlockPos pos = mill.getBlockPos();
        BlockState state = mill.getBlockState();
        Level level = mill.getLevel();
        if (level == null) {
            return Optional.empty();
        }
        Direction facing = RiceMillBlock.getFacing(state);
        Direction attached_dir = facing.getClockWise();
        BlockPos attach_pos = pos.offset(attached_dir.getStepX(), 0, attached_dir.getStepZ());
        BlockEntity attach_blockEntity = level.getBlockEntity(attach_pos);
        if (attach_blockEntity instanceof FurnaceBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof SmokerBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof ChestBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof HopperBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        return Optional.empty();
    }

    private static ItemStack tryEjectToRecipent(BlockEntity recipent, ItemStack currentStack) {
        if (currentStack.isEmpty()) {
            return currentStack;
        }
        if (recipent instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)recipent;
            int furnaceIn = FurnaceBlockEntityDelegate.FURNACE_IN;
            ItemStack current_in = furnace.getItem(furnaceIn);
            if (!current_in.isEmpty() && !ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)current_in)) {
                return currentStack;
            }
            if (!current_in.isEmpty() && current_in.getCount() >= InventoryUtil.maxStackSizeWithContainer((Container)furnace, furnaceIn, current_in)) {
                return currentStack;
            }
            if (!furnace.canPlaceItem(furnaceIn, currentStack)) {
                return currentStack;
            }
            if (current_in.isEmpty()) {
                current_in = new ItemStack((ItemLike)currentStack.getItem());
            } else {
                current_in = current_in.copy();
                current_in.grow(1);
            }
            furnace.setItem(furnaceIn, current_in);
            currentStack = currentStack.copy();
            currentStack.shrink(1);
            return currentStack;
        }
        if (recipent instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)recipent;
            currentStack = RiceMillBlockEntity.tryInputStackInContainer(currentStack, (Container)chest);
        } else if (recipent instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)recipent;
            currentStack = RiceMillBlockEntity.tryInputStackInContainer(currentStack, (Container)hopper);
        }
        return currentStack;
    }

    private static ItemStack tryInputStackInContainer(ItemStack currentStack, Container target) {
        int freeSlot = -1;
        for (int i = 0; i < target.getContainerSize(); ++i) {
            ItemStack item = target.getItem(i);
            if (item.isEmpty()) {
                freeSlot = i;
                break;
            }
            if (!ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)item) || item.getCount() >= InventoryUtil.maxStackSizeWithContainer(target, i, item)) continue;
            freeSlot = i;
            break;
        }
        if (freeSlot < 0) {
            return currentStack;
        }
        ItemStack targetItem = target.getItem(freeSlot);
        if (!targetItem.isEmpty() && !ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)targetItem)) {
            return currentStack;
        }
        if (!targetItem.isEmpty() && targetItem.getCount() >= InventoryUtil.maxStackSizeWithContainer(target, freeSlot, targetItem)) {
            return currentStack;
        }
        if (!target.canPlaceItem(freeSlot, targetItem)) {
            return currentStack;
        }
        if (targetItem.isEmpty()) {
            targetItem = new ItemStack((ItemLike)currentStack.getItem());
        } else {
            targetItem = targetItem.copy();
            targetItem.grow(1);
        }
        target.setItem(freeSlot, targetItem);
        currentStack = currentStack.copy();
        currentStack.shrink(1);
        return currentStack;
    }

    public WorldlyContainer getWorldlyContainer() {
        return this.container;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        AABB aabb = new AABB(pos);
        Direction facing = RiceMillBlock.getFacing(state);
        Vec3i facing_norm = facing.getUnitVec3i();
        Vec3 expand_vec = new Vec3((double)facing_norm.getX(), 1.5, (double)facing_norm.getZ());
        aabb = aabb.expandTowards(expand_vec);
        Direction.Axis side_axis = facing.getClockWise().getAxis();
        aabb = side_axis == Direction.Axis.X ? aabb.inflate(1.5, 0.0, 0.0) : aabb.inflate(0.0, 0.0, 1.5);
        return aabb;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider prov) {
        super.loadAdditional(tag, prov);
        this.container.deserializeNBT(tag, prov);
        this.grindingTime = CompoundTag_1_21_5.wrap(tag).getInt("grindingTime");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider prov) {
        super.saveAdditional(tag, prov);
        this.container.serializeNBT(tag, prov);
        tag.putInt("grindingTime", this.grindingTime);
    }

    public static class MillRecipe {
        public static MillRecipe EMPTY = Builder.empty().build();
        private Item inputItem = null;
        private int inputAmount = 0;
        private boolean needBowl = true;
        private Item outputItem = null;
        private int outputAmount = 1;

        private MillRecipe() {
        }

        public Item inputItem() {
            return this.inputItem;
        }

        public int inputAmount() {
            return this.inputAmount;
        }

        public boolean needBowl() {
            return this.needBowl;
        }

        @Nullable
        public Item outputItem() {
            return this.outputItem;
        }

        public int outputAmount() {
            return this.outputAmount;
        }

        public boolean empty() {
            return this.outputItem == null || this.inputItem == null;
        }

        public boolean matches(ItemStack inputStack, boolean hasBowl) {
            if (this.empty()) {
                return false;
            }
            if (hasBowl != this.needBowl) {
                return false;
            }
            if (inputStack == null) {
                return false;
            }
            if (!inputStack.is(this.inputItem)) {
                return false;
            }
            return inputStack.getCount() >= this.inputAmount;
        }

        public ItemStack produce() {
            if (this.empty()) {
                return ItemStack.EMPTY;
            }
            if (this.outputItem == null) {
                return ItemStack.EMPTY;
            }
            return new ItemStack((ItemLike)this.outputItem, this.outputAmount);
        }

        public static class Builder {
            private Item inputItem = null;
            private int inputAmount = 0;
            private boolean needBowl = false;
            private Item outputItem = null;
            private int outputAmount = 1;

            private Builder() {
            }

            public static Builder empty() {
                return new Builder();
            }

            public static Builder withInput(Item item, int amount) {
                Builder ret = new Builder();
                ret.inputItem = item;
                ret.inputAmount = amount;
                return ret;
            }

            public Builder needsBowl() {
                this.needBowl = true;
                return this;
            }

            public Builder withOutput(Item item, int amount) {
                this.outputAmount = amount;
                this.outputItem = item;
                return this;
            }

            public MillRecipe build() {
                MillRecipe ret = new MillRecipe();
                ret.inputItem = this.inputItem;
                ret.inputAmount = this.inputAmount;
                ret.needBowl = this.needBowl;
                ret.outputItem = this.outputItem;
                ret.outputAmount = this.outputAmount;
                return ret;
            }
        }
    }

    public static class RiceMillContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final RiceMillBlockEntity mill;

        public RiceMillContainer(RiceMillBlockEntity mill) {
            super(3);
            this.mill = mill;
        }

        public int[] getSlotsForFace(Direction dir) {
            if (dir.getAxis() == Direction.Axis.Y) {
                return new int[0];
            }
            BlockState state = this.mill.getBlockState();
            Direction facing = RiceMillBlock.getFacing(state);
            if (facing.getCounterClockWise() == dir) {
                return INPUT_SLOT;
            }
            return new int[0];
        }

        public boolean canPlaceItemThroughFace(int slotId, ItemStack stack, @Nullable Direction dir) {
            if (dir == null) {
                return false;
            }
            if (dir.getAxis() == Direction.Axis.Y) {
                return false;
            }
            BlockState state = this.mill.getBlockState();
            Direction facing = RiceMillBlock.getFacing(state);
            if (facing.getCounterClockWise() == dir) {
                return this.mill.isInputMaterialForSlotId(stack, slotId);
            }
            return false;
        }

        public boolean canTakeItemThroughFace(int slotId, ItemStack stack, Direction dir) {
            return false;
        }

        public void setChanged() {
            this.mill.setChanged();
        }

        public boolean stillValid(Player player) {
            return Container.stillValidBlockEntity((BlockEntity)this.mill, (Player)player);
        }

        public void serializeNBT(CompoundTag compound, HolderLookup.Provider prov) {
            ListTag itemsList = new ListTag();
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putByte("Slot", (byte)i);
                itemsList.add((Object)stack.save(prov, (Tag)itemTag));
            }
            compound.put("MillItems", (Tag)itemsList);
        }

        public void deserializeNBT(CompoundTag compound_1_21_5, HolderLookup.Provider prov) {
            CompoundTag_1_21_5 compound = CompoundTag_1_21_5.wrap(compound_1_21_5);
            if (compound.contains("MillItems", 9)) {
                ListTag_1_21_5 tagList = compound.getList("MillItems", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag_1_21_5 itemTag = tagList.getCompound(i);
                    int slot = itemTag.getInt("Slot");
                    if (slot < 0 || slot >= this.getContainerSize()) continue;
                    this.setItem(slot, ItemStack.parse((HolderLookup.Provider)prov, (Tag)itemTag.wrapped()).orElse(ItemStack.EMPTY));
                }
            }
        }
    }

    public static class RiceMillSyncedData
    implements ContainerData {
        private final RiceMillBlockEntity mill;

        public RiceMillSyncedData(RiceMillBlockEntity mill) {
            this.mill = mill;
        }

        public int get(int syncedSlotId) {
            switch (syncedSlotId) {
                case 0: {
                    return this.mill.grindingTime;
                }
                case 1: {
                    return this.mill.grindingTimeWhenFinish;
                }
            }
            return 0;
        }

        public void set(int syncedSlotId, int val) {
        }

        public int getCount() {
            return 2;
        }
    }

    public static class RiceMillMenuProvider
    implements MenuProvider {
        private final RiceMillBlockEntity mill;

        public RiceMillMenuProvider(RiceMillBlockEntity mill) {
            this.mill = mill;
        }

        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory inv, Player player) {
            return new RiceMillMenu(containerId, inv, (Container)this.mill.container, this.mill.syncedData);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.doggytalents.rice_mill");
        }
    }

    public static class FurnaceBlockEntityDelegate
    extends AbstractFurnaceBlockEntity {
        public static int FURNACE_IN = 0;

        protected FurnaceBlockEntityDelegate(BlockEntityType<?> p_154991_, BlockPos p_154992_, BlockState p_154993_, RecipeType<? extends AbstractCookingRecipe> p_154994_) {
            super(p_154991_, p_154992_, p_154993_, p_154994_);
        }

        protected Component getDefaultName() {
            return Component.empty();
        }

        protected AbstractContainerMenu createMenu(int p_58627_, Inventory p_58628_) {
            return null;
        }
    }
}

