/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DisplayInfoBuilder {
    private Component title;
    private Component description;
    private ItemStack icon;
    private ResourceLocation background;
    private AdvancementType frame;
    private boolean showToast = true;
    private boolean announceToChat = true;
    private boolean hidden = false;

    public DisplayInfoBuilder translate(ResourceLocation key) {
        return this.translate(key.getNamespace() + "." + key.getPath());
    }

    public DisplayInfoBuilder translate(String key) {
        this.title((Component)Component.translatable((String)("advancements.doggytalents." + key + ".title")));
        this.description((Component)Component.translatable((String)("advancements.doggytalents." + key + ".description")));
        return this;
    }

    public DisplayInfoBuilder title(Component titleIn) {
        this.title = titleIn;
        return this;
    }

    public DisplayInfoBuilder description(Component descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    public DisplayInfoBuilder icon(Supplier<? extends ItemLike> stackIn) {
        return this.icon(stackIn.get());
    }

    public DisplayInfoBuilder icon(ItemLike provider) {
        return this.icon(new ItemStack((ItemLike)provider.asItem()));
    }

    public DisplayInfoBuilder icon(ItemStack stackIn) {
        this.icon = stackIn;
        return this;
    }

    public DisplayInfoBuilder background(String path) {
        return this.background(Util.getVanillaResource("textures/gui/advancements/backgrounds/" + path));
    }

    public DisplayInfoBuilder background(String modId, String path) {
        return this.background(Util.getResource(modId, "textures/gui/advancements/backgrounds/" + path));
    }

    public DisplayInfoBuilder background(ResourceLocation backgroundIn) {
        this.background = backgroundIn;
        return this;
    }

    public DisplayInfoBuilder frame(AdvancementType frameIn) {
        this.frame = frameIn;
        return this;
    }

    public DisplayInfoBuilder noToast() {
        this.showToast = false;
        return this;
    }

    public DisplayInfoBuilder noAnnouncement() {
        this.announceToChat = false;
        return this;
    }

    public DisplayInfoBuilder hide() {
        this.hidden = true;
        return this;
    }

    public DisplayInfo build() {
        return new DisplayInfo(this.icon, this.title, this.description, Optional.ofNullable(this.background).map(x -> new ClientAsset(x)), this.frame, this.showToast, this.announceToChat, this.hidden);
    }

    public static DisplayInfoBuilder create() {
        return new DisplayInfoBuilder();
    }
}

