/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyEntityTypes;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class DogAllyCheck {
    private static final ThreadLocal<Boolean> isMixinCalling = ThreadLocal.withInitial(() -> false);

    public static boolean isAlliedToDog(Dog dog, Entity entity) {
        return DogAllyCheck.isAlliedToDog(dog, entity, dog.getOwner());
    }

    public static boolean isAlliedToDog(Dog dog, Entity entity, @Nullable LivingEntity owner) {
        boolean ally_check;
        if (dog == null || entity == null) {
            return false;
        }
        if (entity == dog) {
            return true;
        }
        UUID owner_uuid = dog.getOwnerUUID();
        if (owner_uuid == null) {
            return false;
        }
        boolean bl = ally_check = owner != null ? DogAllyCheck.checkOwnerAvailable(dog, entity, owner_uuid, owner) : DogAllyCheck.checkOwnerNotAvailable(dog, entity, owner_uuid);
        if (ally_check) {
            return true;
        }
        boolean all_player_ally_to_dog = DogAllyCheck.checkAllPlayerCannotHitDog(dog, entity);
        return all_player_ally_to_dog;
    }

    private static boolean checkOwnerAvailable(Dog dog, Entity entity, UUID owner_uuid, LivingEntity owner) {
        TamableAnimal other_dog;
        if (entity == owner) {
            return true;
        }
        if (entity.getType() != DoggyEntityTypes.DOG.get() && owner.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof TamableAnimal && EntityUtil_1_21_5.getOwnerUUID(other_dog = (TamableAnimal)entity) != null) {
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            LivingEntity owner_other = other_dog.getOwner();
            if (owner_other != null) {
                return owner.isAlliedTo((Entity)owner_other);
            }
            if (other_dog instanceof Dog) {
                Dog other_dog_actual = (Dog)other_dog;
                return DogAllyCheck.checkSameTeamWithOfflineOwner(other_dog_actual, (Entity)owner);
            }
            Optional<Team> other_team = DogAllyCheck.findOwnerTeam(other_dog);
            if (other_team.isPresent()) {
                return owner.isAlliedTo(other_team.get());
            }
            return false;
        }
        return false;
    }

    private static boolean checkOwnerNotAvailable(Dog dog, Entity entity, UUID owner_uuid) {
        TamableAnimal other_dog;
        if (entity instanceof TamableAnimal && EntityUtil_1_21_5.getOwnerUUID(other_dog = (TamableAnimal)entity) != null) {
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            return DogAllyCheck.checkSameTeamWithOfflineOwnerTamable(dog, other_dog);
        }
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, entity);
    }

    private static boolean checkSameTeamWithOfflineOwner(Dog dog, Entity entity) {
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, (Team)entity.getTeam());
    }

    private static boolean checkSameTeamWithOfflineOwnerTamable(Dog dog, TamableAnimal entity) {
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, DogAllyCheck.findTamableTeam(entity));
    }

    private static Team findTamableTeam(TamableAnimal other_dog) {
        return DogAllyCheck.findOwnerTeam(other_dog).orElseGet(() -> ((TamableAnimal)other_dog).getTeam());
    }

    private static Optional<Team> findOwnerTeam(TamableAnimal other_dog) {
        UUID uuid = EntityUtil_1_21_5.getOwnerUUID(other_dog);
        if (uuid == null) {
            return Optional.empty();
        }
        MinecraftServer server = other_dog.level().getServer();
        if (server == null) {
            return Optional.empty();
        }
        ServerPlayer player = server.getPlayerList().getPlayer(uuid);
        if (player == null) {
            return Optional.empty();
        }
        ServerScoreboard scoreboard = server.getScoreboard();
        PlayerTeam ret = scoreboard.getPlayersTeam(player.getScoreboardName());
        return Optional.ofNullable(ret);
    }

    private static boolean checkSameTeamWithOfflineOwner(Dog dog, Team other_team) {
        if (other_team == null) {
            return false;
        }
        Optional<Component> owner_name_optional = dog.getOwnersName();
        if (!owner_name_optional.isPresent()) {
            return false;
        }
        String owner_name = owner_name_optional.get().getString();
        if (owner_name == null || owner_name.isEmpty()) {
            return false;
        }
        return other_team.getPlayers().contains(owner_name);
    }

    private static boolean checkSameOwnerUUIDWithDog(UUID dog_owner_uuid, TamableAnimal entity) {
        UUID other_owner_uuid = EntityUtil_1_21_5.getOwnerUUID(entity);
        if (other_owner_uuid == null) {
            return false;
        }
        return dog_owner_uuid.equals(other_owner_uuid);
    }

    private static boolean checkAllPlayerCannotHitDog(Dog dog, Entity entity) {
        if (!((Boolean)ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG.get()).booleanValue()) {
            return false;
        }
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal other_dog = (TamableAnimal)entity;
            return EntityUtil_1_21_5.getOwnerUUID(other_dog) != null;
        }
        return false;
    }

    public static boolean onEntityIsAlliedToServer(Entity self, Entity entity) {
        boolean entity_type_check;
        boolean bl = entity_type_check = self.getType() == EntityType.PLAYER && entity.getType() == DoggyEntityTypes.DOG.get();
        if (!entity_type_check) {
            return false;
        }
        if (isMixinCalling.get().booleanValue()) {
            return false;
        }
        if (!(entity instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)entity;
        isMixinCalling.set(true);
        boolean result = DogAllyCheck.isAlliedToDog(dog, self);
        isMixinCalling.set(false);
        return result;
    }
}

