/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class DogLowHealthGoal {

    public static class RunAway
    extends Goal {
        public static final int CAUTIOUS_RADIUS = 6;
        private Type type = Type.OWNER;
        private Dog dog;
        private float oldWaterCost;
        private int tickTillMoveAwayRecalc = 0;
        private int tickTillCheckTeleport = 0;
        private LivingEntity owner;
        private BlockPos restrictPos;
        private Vec3 moveAwayPos;
        private List<Mob> enemies = List.of();
        private int tickTillUpdateEnemyRecalc = 0;

        public RunAway(Dog dog) {
            this.dog = dog;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.tickTillUpdateEnemyRecalc > 0) {
                --this.tickTillUpdateEnemyRecalc;
            }
            if (!this.dog.isDoingFine()) {
                return false;
            }
            if (this.dog.isInSittingPose()) {
                return false;
            }
            if (!this.dog.isDogLowHealth()) {
                return false;
            }
            if (this.dog.getLowHealthStrategy() != Dog.LowHealthStrategy.RUN_AWAY) {
                return false;
            }
            if (this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT, DogMode.GUARD_MINOR)) {
                return false;
            }
            if (this.dog.getMode().shouldFollowOwner()) {
                LivingEntity owner = this.dog.getOwner();
                if (owner == null) {
                    return false;
                }
                this.owner = owner;
                this.type = Type.OWNER;
            } else {
                if (!this.dog.getMode().canWander()) {
                    return false;
                }
                if (!this.dog.hasRestriction() || this.dog.getRestrictCenter() == null) {
                    return false;
                }
                this.restrictPos = this.dog.getRestrictCenter();
                this.type = Type.RESTRICT;
            }
            this.enemies = List.of();
            if (this.tickTillUpdateEnemyRecalc <= 0) {
                this.tickTillUpdateEnemyRecalc = 3;
                this.updateEnemies(6);
            }
            return !this.enemies.isEmpty();
        }

        public boolean canContinueToUse() {
            if (this.enemies.isEmpty()) {
                return false;
            }
            if (this.type == Type.OWNER) {
                if (!this.dog.getMode().shouldFollowOwner()) {
                    return false;
                }
                if (!this.owner.canBeSeenByAnyone()) {
                    return false;
                }
            } else {
                if (!this.dog.getMode().canWander()) {
                    return false;
                }
                if (!this.dog.hasRestriction() || this.dog.getRestrictCenter() == null) {
                    return false;
                }
                if (!this.restrictPos.equals((Object)this.dog.getRestrictCenter())) {
                    return false;
                }
            }
            return this.dog.isDogLowHealth();
        }

        public void start() {
            this.oldWaterCost = this.dog.getPathfindingMalus(PathType.WATER);
            this.dog.setDogFollowingSomeone(true);
            this.dog.getNavigation().stop();
            this.moveAwayPos = this.findMoveAwayPos();
            if (this.moveAwayPos != null) {
                this.tickTillMoveAwayRecalc = 5;
                this.dog.getNavigation().moveTo(this.moveAwayPos.x, this.moveAwayPos.y, this.moveAwayPos.z, (double)this.dog.getUrgentSpeedModifier());
            }
        }

        public void tick() {
            PathNavigation dogNav = this.dog.getNavigation();
            if (--this.tickTillMoveAwayRecalc <= 0) {
                this.tickTillMoveAwayRecalc = 3 + this.dog.getRandom().nextInt(3);
                this.updateMoveAway();
                if (this.moveAwayPos != null) {
                    dogNav.moveTo(this.moveAwayPos.x, this.moveAwayPos.y, this.moveAwayPos.z, (double)this.dog.getUrgentSpeedModifier());
                }
            }
            if (--this.tickTillCheckTeleport <= 0) {
                this.tickTillCheckTeleport = 5;
                if (this.type == Type.OWNER && this.dog.getMode().shouldFollowOwner() && this.dog.distanceToSqr((Entity)this.owner) > 400.0) {
                    DogUtil.dynamicSearchAndTeleportToOwnwer(this.dog, this.owner, 4);
                }
            }
        }

        private void updateEnemies(int search_radius) {
            this.enemies = this.dog.level().getEntitiesOfClass(Mob.class, this.dog.getBoundingBox().inflate((double)search_radius, 3.0, (double)search_radius), mob -> mob.isAlive() && mob.getTarget() == this.dog);
        }

        private void updateMoveAway() {
            this.moveAwayPos = null;
            this.updateEnemies(6);
            this.moveAwayPos = this.findMoveAwayPos();
        }

        private Vec3 findMoveAwayPos() {
            Vec3 moveAwayPos;
            Vec3 centerPos = this.findAverageCenterOfAllTargetingEnemies();
            if (centerPos == null) {
                return null;
            }
            Vec3 ownerPos = this.type == Type.OWNER ? this.owner.position() : Vec3.atBottomCenterOf((Vec3i)this.restrictPos);
            Vec3 dogPos = this.dog.position();
            Vec3 avoid_offset = dogPos.subtract(centerPos).normalize().scale(8.0);
            Vec3 v_dogPos_ownerPos = ownerPos.subtract(dogPos);
            double alpha = v_dogPos_ownerPos.dot(avoid_offset) / (v_dogPos_ownerPos.length() * avoid_offset.length());
            if (alpha < -0.8) {
                moveAwayPos = this.dog.tickCount % 2 == 0 ? dogPos.add(avoid_offset.z, 0.0, -avoid_offset.x) : dogPos.add(-avoid_offset.z, 0.0, avoid_offset.x);
            } else {
                Vec3 avoidPos = dogPos.add(avoid_offset);
                moveAwayPos = new Vec3((avoidPos.x + ownerPos.x) / 2.0, (avoidPos.y + ownerPos.y) / 2.0, (avoidPos.z + ownerPos.z) / 2.0);
            }
            return moveAwayPos;
        }

        public Vec3 findAverageCenterOfAllTargetingEnemies() {
            if (this.enemies.isEmpty()) {
                return null;
            }
            double size = this.enemies.size();
            double avg_x = 0.0;
            double avg_y = 0.0;
            double avg_z = 0.0;
            for (Mob enemy : this.enemies) {
                avg_x += enemy.getX();
                avg_y += enemy.getY();
                avg_z += enemy.getZ();
            }
            return new Vec3(avg_x /= size, avg_y /= size, avg_z /= size);
        }

        public void stop() {
            this.dog.getNavigation().stop();
            this.dog.setDogFollowingSomeone(false);
            this.owner = null;
            this.enemies = List.of();
            this.moveAwayPos = null;
        }

        private static enum Type {
            OWNER,
            RESTRICT;

        }
    }

    public static class StickToOwner
    extends Goal {
        private final Dog dog;
        private final float stopDist;
        private LivingEntity owner;
        private int timeToRecalcPath;
        private int tickTillSearchForTp = 0;
        private int tickTillInitTeleport = 0;
        private int tickTillInitWhine = 0;
        private float oldWaterCost;
        private boolean whine = false;

        public StickToOwner(Dog dogIn) {
            this.dog = dogIn;
            this.stopDist = 1.5f;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity owner;
            if (this.tickTillInitTeleport > 0) {
                --this.tickTillInitTeleport;
            }
            if (this.tickTillInitWhine > 0) {
                --this.tickTillInitWhine;
            }
            if ((owner = this.dog.getOwner()) == null) {
                return false;
            }
            if (!this.dog.isDoingFine()) {
                return false;
            }
            if (!this.dog.isDogLowHealth()) {
                return false;
            }
            if (this.dog.getLowHealthStrategy() != Dog.LowHealthStrategy.STICK_TO_OWNER) {
                return false;
            }
            if (owner.isSpectator()) {
                return false;
            }
            if (this.dog.isInSittingPose()) {
                return false;
            }
            this.owner = owner;
            return true;
        }

        public boolean canContinueToUse() {
            return this.dog.isDogLowHealth();
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.dog.getPathfindingMalus(PathType.WATER);
            this.dog.setDogFollowingSomeone(true);
            this.whine = true;
            if (this.tickTillInitTeleport <= 0) {
                this.tickTillInitTeleport = 10;
                DogUtil.dynamicSearchAndTeleportToOwnwer(this.dog, this.owner, 4);
            }
        }

        public void stop() {
            double distanceToOwner;
            if (this.dog.hasBone() && (distanceToOwner = this.owner.distanceToSqr((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
                IThrowableItem throwableItem = this.dog.getThrowableItem();
                ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
                this.dog.spawnAtLocation((ServerLevel)this.dog.level(), fetchItem, 0.0f);
                this.dog.setBoneVariant(ItemStack.EMPTY);
            }
            this.owner = null;
            this.dog.getNavigation().stop();
            this.dog.setDogFollowingSomeone(false);
            this.dog.setBegging(false);
            this.dog.dogSoundManager.interuptPlaying();
        }

        public void tick() {
            if (this.tickTillInitWhine > 0) {
                --this.tickTillInitWhine;
            }
            if (this.dog.distanceToSqr((Entity)this.owner) > (double)(this.stopDist * this.stopDist)) {
                this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 5;
                    DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 25.0, false, --this.tickTillSearchForTp <= 0, 400.0, this.dog.getMaxFallDistance());
                    if (this.tickTillSearchForTp <= 0) {
                        this.tickTillSearchForTp = 10;
                    }
                }
            } else {
                if (this.whine && this.tickTillInitWhine <= 0) {
                    this.whine = false;
                    PlayerUtil.sendSystemMessage(this.owner, (Component)Component.translatable((String)("dog.msg.low_health." + this.dog.getRandom().nextInt(4)), (Object[])new Object[]{this.dog.getName()}));
                    SoundEvent sound = this.dog.dogMood.getWhineAttentionSound();
                    this.dog.dogSoundManager.playInterruptible(sound, this.dog.getSoundVolume(), this.dog.getVoicePitch());
                    this.tickTillInitWhine = 40;
                }
                this.dog.getLookControl().setLookAt((Entity)this.owner);
            }
        }
    }
}

