/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.talent.OokamiKazeTalent;
import doggytalents.common.util.DogUtil;
import java.util.List;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DogGunpowderProjectile
extends ThrowableProjectile {
    private int tickTillScan = 0;

    public DogGunpowderProjectile(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public DogGunpowderProjectile(Level worldIn, LivingEntity livingEntityIn) {
        super(DoggyEntityTypes.DOG_GUNPOWDER_PROJ.get(), livingEntityIn.getX(), livingEntityIn.getEyeY() - (double)0.1f, livingEntityIn.getZ(), worldIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder b) {
    }

    protected void onHit(HitResult hitResult) {
        if (this.level().isClientSide) {
            return;
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        if (!this.level().isClientSide) {
            this.spawnAtLocation((ServerLevel)this.level(), new ItemStack((ItemLike)Items.GUNPOWDER));
        }
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.scanDogAroundAndTrigger();
        }
    }

    private void scanDogAroundAndTrigger() {
        if (this.tickTillScan > 0) {
            --this.tickTillScan;
            return;
        }
        if (this.getOwner() == null) {
            return;
        }
        Vec3 pos = this.position();
        AABB aabb = new AABB(pos.add(-5.0, -5.0, -5.0), pos.add(5.0, 0.0, 5.0));
        Vec3 moveVec = this.getDeltaMovement();
        Vec3 moveVecXZ = new Vec3(moveVec.x, 0.0, moveVec.z).normalize();
        if (moveVecXZ.length() < 1.0) {
            return;
        }
        List dogs = this.level().getEntitiesOfClass(Dog.class, aabb, filter_dog -> this.isValidDog((Dog)filter_dog, moveVecXZ));
        if (dogs.isEmpty()) {
            return;
        }
        this.tickTillScan = 3;
        Dog nearestDog = (Dog)dogs.get(0);
        double minDist = nearestDog.distanceToSqr((Entity)this);
        for (Dog dog : dogs) {
            double dist = dog.distanceToSqr((Entity)this);
            if (!(dist < minDist)) continue;
            nearestDog = dog;
            minDist = dist;
        }
        OokamiKazeTalent talentInst = nearestDog.getTalent(DoggyTalents.OOKAMIKAZE).map(inst -> inst.cast(OokamiKazeTalent.class)).orElse(null);
        if (talentInst == null) {
            return;
        }
        if (!talentInst.canExplode()) {
            return;
        }
        double dy = this.position().y - nearestDog.position().y;
        double minDistXZ = new Vec3(this.position().x - nearestDog.position().x, 0.0, this.position().z - nearestDog.position().z).lengthSqr();
        if (minDist < 4.0) {
            nearestDog.triggerAction(talentInst.actionCreator(nearestDog, null));
            this.feedDog(nearestDog);
        } else if (dy >= 1.5 && minDistXZ >= 10.0) {
            nearestDog.triggerAction(talentInst.actionCreator(nearestDog, this));
        }
    }

    private boolean isValidDog(Dog dog, Vec3 lookVecXZ) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.isOrderedToSit()) {
            return false;
        }
        if (dog.getOwner() != this.getOwner()) {
            return false;
        }
        if (!this.checkIfDogCanCatch(dog, lookVecXZ) && dog.distanceToSqr((Entity)this) >= 4.0) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return dog.getDogLevel(DoggyTalents.OOKAMIKAZE.get()) > 0;
    }

    private boolean checkIfDogCanCatch(Dog dog, Vec3 lookVecXZ) {
        Vec3 dogPosXZ = new Vec3(dog.position().x, 0.0, dog.position().z);
        Vec3 posXZ = new Vec3(this.position().x, 0.0, this.position().z);
        double dist = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(dogPosXZ, posXZ, lookVecXZ);
        if (dist < 0.0) {
            return false;
        }
        return dist < 2.25;
    }

    public void feedDog(Dog dog) {
        if (dog.level() instanceof ServerLevel) {
            ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)Items.GUNPOWDER));
        }
        dog.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), dog.getSoundVolume(), (dog.getRandom().nextFloat() - dog.getRandom().nextFloat()) * 0.2f + 1.0f);
        this.discard();
    }
}

