/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.common.talent.PackPuppyTalent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PackPuppyItemHandler
extends ItemStackHandler {
    private PackPuppyTalent inst;

    public PackPuppyItemHandler(PackPuppyTalent inst) {
        super(15);
        this.inst = inst;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider prov) {
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            itemsList.add((Object)stack.save(prov, (Tag)itemTag));
        }
        CompoundTag compound = new CompoundTag();
        compound.put("items", (Tag)itemsList);
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider prov, CompoundTag compound_1_21_5) {
        CompoundTag_1_21_5 compound = CompoundTag_1_21_5.wrap(compound_1_21_5);
        if (compound.contains("items", 9)) {
            try {
                ListTag_1_21_5 tagList = compound.getList("items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag_1_21_5 itemTag = tagList.getCompound(i);
                    int slot = itemTag.getInt("Slot");
                    if (slot < 0 || slot >= this.stacks.size()) continue;
                    ItemStack.parse((HolderLookup.Provider)prov, (Tag)itemTag.wrapped()).ifPresent(stack -> this.stacks.set(slot, stack));
                }
                this.onLoad();
            }
            catch (Exception tagList) {}
        } else if (compound.contains("packpuppyitems", 9)) {
            ListTag_1_21_5 tagList = compound.getList("packpuppyitems", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag_1_21_5 itemTag = tagList.getCompound(i);
                int slot = itemTag.getInt("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                ItemStack.parse((HolderLookup.Provider)prov, (Tag)itemTag.wrapped()).ifPresent(stack -> this.stacks.set(slot, stack));
            }
            this.onLoad();
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= this.inst.level() * 3) {
            return false;
        }
        return super.isItemValid(slot, stack);
    }
}

