/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyEntityTypes;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.event.EventHandler;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DoggyCharmItem
extends Item
implements IDogItem,
HoverTextAppender_1_21_5 {
    public DoggyCharmItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide || !(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction enumfacing = context.getClickedFace();
        BlockState iblockstate = world.getBlockState(blockpos);
        if (player == null) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            return InteractionResult.SUCCESS;
        }
        if (!EventHandler.isWithinTrainWolfLimit(player)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockpos1 = iblockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty() ? blockpos : blockpos.relative(enumfacing);
        Entity entity = DoggyEntityTypes.DOG.get().spawn((ServerLevel)world, itemstack, (LivingEntity)context.getPlayer(), blockpos1, EntitySpawnReason.SPAWN_ITEM_USE, !Objects.equals(blockpos, blockpos1) && enumfacing == Direction.UP, false);
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            if (player != null) {
                dog.setTame(true, true);
                dog.setOwnerUUID(player.getUUID());
                dog.maxHealth();
                if (((Boolean)ConfigHandler.SERVER.RANDOM_VAR_WITH_CHARM.get()).booleanValue()) {
                    dog.setDogVariant(DogVariantUtil.getRandom(dog.getRandom()));
                }
            }
            itemstack.shrink(1);
            if (player instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(sP, blockpos1, itemstack);
                PlayerUtil.addCooldown((Player)sP, this, 30);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (worldIn.isClientSide || !(worldIn instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        if (playerIn == null) {
            return InteractionResult.PASS;
        }
        if (!EventHandler.isWithinTrainWolfLimit(playerIn)) {
            return InteractionResult.PASS;
        }
        BlockHitResult raytraceresult = Item.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult != null && raytraceresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            if (!(worldIn.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
                return InteractionResult.PASS;
            }
            if (worldIn.mayInteract((Entity)playerIn, blockpos) && playerIn.mayUseItemAt(blockpos, raytraceresult.getDirection(), itemstack)) {
                Entity entity = DoggyEntityTypes.DOG.get().spawn((ServerLevel)worldIn, itemstack, (LivingEntity)playerIn, blockpos, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
                if (entity instanceof Dog) {
                    Dog dog = (Dog)entity;
                    dog.setTame(true, true);
                    dog.setOwnerUUID(playerIn.getUUID());
                    dog.maxHealth();
                    if (((Boolean)ConfigHandler.SERVER.RANDOM_VAR_WITH_CHARM.get()).booleanValue()) {
                        dog.setDogVariant(DogVariantUtil.getRandom(dog.getRandom()));
                    }
                    itemstack.shrink(1);
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer sP = (ServerPlayer)playerIn;
                        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(sP, blockpos, itemstack);
                    }
                    playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
                    PlayerUtil.addCooldown(playerIn, this, 30);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player player, InteractionHand handIn) {
        if (!(dogIn instanceof Dog)) {
            return DogInteractionResult.FAIL;
        }
        Dog dog = (Dog)dogIn;
        if (!player.isCreative()) {
            return DogInteractionResult.FAIL;
        }
        if (!player.isShiftKeyDown()) {
            return DogInteractionResult.FAIL;
        }
        if (!dog.canInteract((LivingEntity)player)) {
            return DogInteractionResult.FAIL;
        }
        if (dog.level().isClientSide) {
            return DogInteractionResult.SUCCESS;
        }
        DogVariant current_variant = dog.dogVariant();
        DogVariant next_variant = DogVariantUtil.cycle(current_variant);
        dog.setDogVariant(next_variant);
        return DogInteractionResult.SUCCESS;
    }

    public boolean isFoil(ItemStack stack) {
        return DoggyCharmItem.isCharmForcedGlint(stack) || super.isFoil(stack);
    }

    public static boolean isCharmForcedGlint(ItemStack stack) {
        return ItemUtil.getWrappedTag(stack).contains("dtn_charm_forced_glint");
    }

    public static void setCharmForcedGlint(ItemStack stack, boolean glint) {
        ItemUtil.modifyTag(stack, tg -> {
            if (glint) {
                tg.putBoolean("dtn_charm_forced_glint", true);
            } else {
                tg.remove("dtn_charm_forced_glint");
            }
        });
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId() + ".description";
        components.add((Component)Component.translatable((String)desc_id));
    }
}

