/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.feature.DogGender;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.PlayerUtil;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GenderBoneItem
extends Item
implements IDogItem {
    public GenderBoneItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!(dogIn instanceof Dog)) {
            return DogInteractionResult.CONSUME;
        }
        Dog dog = (Dog)dogIn;
        if (!dog.canInteract((LivingEntity)playerIn)) {
            return DogInteractionResult.CONSUME;
        }
        if (PlayerUtil.isOnCooldown(playerIn, DoggyItems.GENDER_BONE.get())) {
            return DogInteractionResult.CONSUME;
        }
        if (dog.level().isClientSide) {
            return DogInteractionResult.SUCCESS;
        }
        dog.setGender(dog.getGender() == DogGender.MALE ? DogGender.FEMALE : DogGender.MALE);
        PlayerUtil.addCooldown(playerIn, DoggyItems.GENDER_BONE.get(), 40);
        dog.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP);
        Level level = dog.level();
        if (level instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            Item item = dog.getGender() == DogGender.MALE ? Items.LIGHT_BLUE_WOOL : Items.PINK_WOOL;
            sL.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)item)), dog.getX(), dog.getY(), dog.getZ(), 24, (double)dog.getBbWidth(), (double)0.8f, (double)dog.getBbWidth(), 0.1);
        }
        ItemStack stack = playerIn.getItemInHand(handIn);
        stack.hurtAndBreak(1, (LivingEntity)playerIn, LivingEntity.getSlotForHand((InteractionHand)handIn));
        return DogInteractionResult.SUCCESS;
    }
}

