/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.client.screen.ConductingBoneScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ConductingBoneData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class ConductingBonePackets {

    public static class RequestDistantTeleportDogPacket
    implements IPacket<ConductingBoneData.RequestDistantTeleportDogData> {
        @Override
        public void encode(ConductingBoneData.RequestDistantTeleportDogData data, FriendlyByteBuf buf) {
            buf.writeUUID(data.dogUUID);
            buf.writeBoolean(data.toBed);
        }

        @Override
        public ConductingBoneData.RequestDistantTeleportDogData decode(FriendlyByteBuf buf) {
            UUID uuid = buf.readUUID();
            boolean toBed = buf.readBoolean();
            return new ConductingBoneData.RequestDistantTeleportDogData(uuid, toBed);
        }

        @Override
        public void handle(ConductingBoneData.RequestDistantTeleportDogData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                    Item item = sender.getItemInHand(InteractionHand.MAIN_HAND).getItem();
                    if (item != DoggyItems.CONDUCTING_BONE.get()) {
                        return;
                    }
                    if (PlayerUtil.isOnCooldown((Player)sender, DoggyItems.CONDUCTING_BONE.get())) {
                        return;
                    }
                    UUID uuid = data.dogUUID;
                    if (uuid == null) {
                        return;
                    }
                    DogLocationStorage storage = DogLocationStorage.get(sender.level());
                    DogLocationData dogData = storage.getData(uuid);
                    if (dogData == null) {
                        return;
                    }
                    if (!sender.getUUID().equals(dogData.getOwnerId())) {
                        return;
                    }
                    if (!data.toBed) {
                        DogUtil.attemptToTeleportDogNearbyOrSendPromise(uuid, sender);
                    } else {
                        ServerLevel sL;
                        Entity e;
                        Level patt0$temp = sender.level();
                        if (patt0$temp instanceof ServerLevel && (e = (sL = (ServerLevel)patt0$temp).getEntity(data.dogUUID)) instanceof Dog) {
                            Dog d = (Dog)e;
                            DogUtil.attemptToTeleportDogToBedOrSendPromise(d);
                        }
                    }
                    PlayerUtil.addCooldown((Player)sender, DoggyItems.CONDUCTING_BONE.get(), 20);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ResponseDogsPackets
    implements IPacket<ConductingBoneData.ResponseDogsData> {
        @Override
        public void encode(ConductingBoneData.ResponseDogsData data, FriendlyByteBuf buf) {
            int size = data.entries.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                Pair<UUID, String> payload = data.entries.get(i);
                UUID uuid = (UUID)payload.getLeft();
                String name = (String)payload.getRight();
                if (uuid == null) {
                    uuid = Util.NIL_UUID;
                }
                if (name == null) {
                    name = "noname";
                }
                buf.writeUUID(uuid);
                buf.writeUtf(name);
            }
        }

        @Override
        public ConductingBoneData.ResponseDogsData decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<Pair<UUID, String>> newDogsLs = new ArrayList<Pair<UUID, String>>(size);
            for (int i = 0; i < size; ++i) {
                UUID id = buf.readUUID();
                String name = buf.readUtf();
                Pair payload = Pair.of((Object)id, (Object)name);
                newDogsLs.add((Pair<UUID, String>)payload);
            }
            return new ConductingBoneData.ResponseDogsData(newDogsLs);
        }

        @Override
        public void handle(ConductingBoneData.ResponseDogsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Screen patt0$temp;
                    Minecraft mc = Minecraft.getInstance();
                    if (mc.screen != null && (patt0$temp = mc.screen) instanceof ConductingBoneScreen) {
                        ConductingBoneScreen scr = (ConductingBoneScreen)patt0$temp;
                        scr.assignResponse(data.entries);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestDogsPacket
    implements IPacket<ConductingBoneData.RequestDogsData> {
        @Override
        public void encode(ConductingBoneData.RequestDogsData data, FriendlyByteBuf buf) {
        }

        @Override
        public ConductingBoneData.RequestDogsData decode(FriendlyByteBuf buf) {
            return new ConductingBoneData.RequestDogsData();
        }

        @Override
        public void handle(ConductingBoneData.RequestDogsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                    DogLocationStorage storage = DogLocationStorage.get(sender.level());
                    Stream<DogLocationData> dogLsStream = (Boolean)ConfigHandler.SERVER.CONDUCTING_BONE_CROSS_ORIGIN.get() != false ? storage.getDogs((LivingEntity)sender) : storage.getDogs((LivingEntity)sender, (ResourceKey<Level>)sender.level().dimension());
                    List<Pair<UUID, String>> dogLs = dogLsStream.map(dogLoc -> Pair.of((Object)dogLoc.getDogId(), (Object)dogLoc.getDogName())).collect(Collectors.toList());
                    PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new ConductingBoneData.ResponseDogsData(dogLs));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

