/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.event.EventHandler;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.TrainWolfToDogData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TrainWolfToDogPacket
implements IPacket<TrainWolfToDogData> {
    @Override
    public void encode(TrainWolfToDogData data, FriendlyByteBuf buf) {
        buf.writeInt(data.wolfId);
        buf.writeFloat(data.wolfYBodyRot);
        buf.writeFloat(data.wolfYHeadRot);
    }

    @Override
    public TrainWolfToDogData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        float body = buf.readFloat();
        float head = buf.readFloat();
        return new TrainWolfToDogData(id, body, head);
    }

    @Override
    public void handle(TrainWolfToDogData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                return;
            }
            ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
            Level level = sender.level();
            Entity e = level.getEntity(data.wolfId);
            if (!(e instanceof Wolf)) {
                return;
            }
            Wolf wolf = (Wolf)e;
            EventHandler.checkAndTrainWolf((Player)sender, wolf, data.wolfYBodyRot, data.wolfYHeadRot);
        });
        ctx.get().setPacketHandled(true);
    }
}

