/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.feature.DogGender;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.LocatorOrbAccessory;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DogLocationData
implements IDogData {
    private final DogLocationStorage storage;
    private final UUID uuid;
    @Nullable
    private UUID ownerId;
    @Nullable
    private UUID sessionUUID;
    @Nullable
    private Vec3 position;
    @Nullable
    private ResourceKey<Level> dimension;
    @Nullable
    private Component name;
    @Nullable
    private DogGender gender;
    private boolean hasRadarCollar;
    private int locateColor;
    private Optional<Dog> cachedDog = Optional.empty();

    protected DogLocationData(DogLocationStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Nullable
    public UUID getSessionUUID() {
        return this.sessionUUID;
    }

    public void setSessionUUID(UUID sessionUUID) {
        this.sessionUUID = sessionUUID;
        this.storage.setDirty();
    }

    @Override
    public String getDogName() {
        return this.name == null ? "" : this.name.getString();
    }

    public void populate(Dog dogIn) {
        this.update(dogIn);
    }

    public void update(Dog dogIn) {
        this.setCachedDog(dogIn);
        this.ownerId = dogIn.getOwnerUUID();
        this.position = dogIn.position();
        this.dimension = dogIn.level().dimension();
        this.name = dogIn.getName();
        this.gender = dogIn.getGender();
        this.updateLocator(dogIn);
        this.storage.setDirty();
    }

    private void updateLocator(Dog dog) {
        this.hasRadarCollar = false;
        this.locateColor = 0;
        Optional<LocatorOrbAccessory> locator_optional = this.checkLocatorOrb(dog);
        if (locator_optional.isPresent()) {
            LocatorOrbAccessory locator = locator_optional.get();
            this.hasRadarCollar = true;
            this.locateColor = locator.getOrbColor();
            return;
        }
        boolean has_radio = this.checkLegacyRadioCollar(dog);
        if (has_radio) {
            this.hasRadarCollar = true;
            return;
        }
    }

    private Optional<LocatorOrbAccessory> checkLocatorOrb(Dog dog) {
        Optional<AccessoryInstance> accessory_optional = dog.getAccessory(DoggyAccessoryTypes.SCARF.get());
        if (!accessory_optional.isPresent()) {
            return Optional.empty();
        }
        AccessoryInstance accessory = accessory_optional.get();
        Accessory accessory2 = accessory.getAccessory();
        if (accessory2 instanceof LocatorOrbAccessory) {
            LocatorOrbAccessory locator = (LocatorOrbAccessory)accessory2;
            return Optional.of(locator);
        }
        return Optional.empty();
    }

    private boolean checkLegacyRadioCollar(Dog dog) {
        Optional<AccessoryInstance> accessory_optional = dog.getAccessory(DoggyAccessoryTypes.RADIO_COLLAR_LEGACY.get());
        return accessory_optional.isPresent();
    }

    public void read(CompoundTag_1_21_5 compound) {
        this.ownerId = NBTUtil.getUniqueId(compound, "ownerId");
        this.position = NBTUtil.getVector3d(compound);
        ResourceLocation dimension = NBTUtil.getResourceLocation(compound, "dimension");
        if (dimension != null) {
            this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension);
        }
        this.name = NBTUtil.getTextComponent(compound, "name_text_component");
        if (compound.contains("gender", 8)) {
            this.gender = DogGender.bySaveName(compound.getString("gender"));
        }
        this.hasRadarCollar = compound.getBoolean("collar");
        if (compound.hasUUID("sessionUUID")) {
            this.sessionUUID = compound.getUUID("sessionUUID");
        }
        this.locateColor = compound.getInt("locateOrbColor");
    }

    public CompoundTag write(CompoundTag compound) {
        NBTUtil.putUniqueId(CompoundTag_1_21_5.wrap(compound), "ownerId", this.getCachedDog().map(Dog::getOwnerUUID).orElse(this.ownerId));
        NBTUtil.putVector3d(compound, this.getCachedDog().map(Entity::position).orElse(this.position));
        ResourceKey<Level> dimension = this.dimension;
        if (dimension != null) {
            NBTUtil.putResourceLocation(compound, "dimension", dimension.location());
        }
        NBTUtil.putTextComponent(compound, "name_text_component", this.name);
        if (this.gender != null) {
            compound.putString("gender", this.gender.getSaveName());
        }
        compound.putBoolean("collar", this.hasRadarCollar);
        if (this.sessionUUID != null) {
            CompoundTag_1_21_5.wrap(compound).putUUID("sessionUUID", this.sessionUUID);
        }
        compound.putInt("locateOrbColor", this.locateColor);
        return compound;
    }

    public static DogLocationData from(DogLocationStorage storageIn, Dog dogIn) {
        DogLocationData locationData = new DogLocationData(storageIn, dogIn.getUUID());
        locationData.populate(dogIn);
        return locationData;
    }

    public boolean shouldDisplay(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (((Boolean)ConfigHandler.SERVER.ALLOW_TRACK_ANY_DOG.get()).booleanValue()) {
            return true;
        }
        return this.hasRadarCollar || playerIn.isCreative() || playerIn.getItemInHand(handIn).getItem() == DoggyItems.CREATIVE_CANINE_TRACKER.get();
    }

    @Nullable
    public Component getName() {
        return this.getCachedDog().map(Entity::getDisplayName).orElse(this.name);
    }

    @Nullable
    public Vec3 getPos(@Nullable ServerLevel worldIn) {
        return this.getCachedDog().map(Entity::position).orElse(this.position);
    }

    public void invalidateCachedDog() {
        this.cachedDog = Optional.empty();
    }

    public Optional<Dog> getCachedDog() {
        this.cachedDog = this.cachedDog.filter(LivingEntity::isAlive);
        return this.cachedDog;
    }

    public void setCachedDog(Dog dog) {
        this.cachedDog = Optional.ofNullable(dog).filter(LivingEntity::isAlive);
    }

    @Nullable
    public Vec3 getPos() {
        return this.position;
    }

    @Nullable
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public int getLocateColor() {
        return this.locateColor;
    }

    public String toString() {
        return "DogLocationData [uuid=" + String.valueOf(this.uuid) + ", owner=" + String.valueOf(this.ownerId) + ", position=" + String.valueOf(this.position) + ", dimension=" + String.valueOf(this.dimension) + ", name=" + String.valueOf(this.name) + ", gender=" + String.valueOf((Object)this.gender) + ", hasRadarCollar=" + this.hasRadarCollar + "]";
    }
}

