/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.LegacyNbtCodec_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.OnlineDogLocationManager;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public class DogLocationStorage
extends SavedData {
    private Map<UUID, DogLocationData> locationDataMap = Maps.newHashMap();
    private final OnlineDogLocationManager onlineDogManager = new OnlineDogLocationManager(this);
    public final Map<UUID, Integer> grettingDogLimitMap = Maps.newHashMap();
    public final Map<UUID, Integer> bridgingDogLimitMap = Maps.newHashMap();

    public static DogLocationStorage get(Level world) {
        if (!(world instanceof ServerLevel)) {
            throw new IllegalStateException("DogLocationStorage is being accessed from the Client Side. Please report to the DTN Team.");
        }
        ServerLevel overworld = world.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (DogLocationStorage)storage.computeIfAbsent(DogLocationStorage.savedDataType_1_21_5("doggytalentsDogLocations"));
    }

    public static DogLocationStorage get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (DogLocationStorage)storage.computeIfAbsent(DogLocationStorage.savedDataType_1_21_5("doggytalentsDogLocations"));
    }

    public Stream<DogLocationData> getDogs(LivingEntity owner) {
        UUID ownerId = owner.getUUID();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<DogLocationData> getDogs(LivingEntity owner, ResourceKey<Level> key) {
        UUID ownerId = owner.getUUID();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId())).filter(data -> key.equals(data.getDimension()));
    }

    @Nullable
    public DogLocationData getData(Dog dogIn) {
        return this.getData(dogIn.getUUID());
    }

    @Nullable
    public DogLocationData getData(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            return this.locationDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogLocationData remove(Dog dogIn) {
        return this.remove(dogIn.getUUID());
    }

    @Nullable
    public DogLocationData getOrCreateData(Dog dogIn) {
        UUID uuid = dogIn.getUUID();
        return this.locationDataMap.computeIfAbsent(uuid, k -> {
            this.setDirty();
            return DogLocationData.from(this, dogIn);
        });
    }

    @Nullable
    public DogLocationData remove(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            DogLocationData storage = this.locationDataMap.remove(uuid);
            this.setDirty();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogLocationData putData(Dog dogIn) {
        UUID uuid = dogIn.getUUID();
        DogLocationData storage = new DogLocationData(this, uuid);
        this.locationDataMap.put(uuid, storage);
        this.setDirty();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.locationDataMap.keySet());
    }

    public Collection<DogLocationData> getAll() {
        return Collections.unmodifiableCollection(this.locationDataMap.values());
    }

    public static DogLocationStorage load(CompoundTag_1_21_5 nbt) {
        DogLocationStorage store = new DogLocationStorage();
        store.locationDataMap.clear();
        ListTag_1_21_5 list = nbt.getList("locationData", 10);
        if (list.isEmpty()) {
            list = nbt.getList("dog_locations", 10);
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag_1_21_5 locationCompound = list.getCompound(i);
            UUID uuid = NBTUtil.getUniqueId(locationCompound, "uuid");
            if (uuid == null) {
                uuid = NBTUtil.getUniqueId(locationCompound, "entityId");
            }
            DogLocationData locationData = new DogLocationData(store, uuid);
            locationData.read(locationCompound);
            if (uuid == null) {
                DoggyTalentsNext.LOGGER.info("Failed to load dog location data. Please report to mod author...");
                DoggyTalentsNext.LOGGER.info((Object)locationData);
                continue;
            }
            store.locationDataMap.put(uuid, locationData);
        }
        return store;
    }

    public CompoundTag_1_21_5 save(CompoundTag_1_21_5 compound) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, DogLocationData> entry : this.locationDataMap.entrySet()) {
            CompoundTag locationCompound = new CompoundTag();
            DogLocationData locationData = entry.getValue();
            NBTUtil.putUniqueId(CompoundTag_1_21_5.wrap(locationCompound), "uuid", entry.getKey());
            locationData.write(locationCompound);
            list.add((Object)locationCompound);
        }
        compound.put("locationData", (Tag)list);
        return compound;
    }

    public boolean isDirty() {
        return true;
    }

    public static void setSessionUUIDFor(Dog dog, UUID sessionUUID) {
        DogLocationStorage storage = DogLocationStorage.get(dog.level());
        if (storage == null) {
            return;
        }
        DogLocationData data = storage.getData(dog);
        if (data == null) {
            return;
        }
        data.setSessionUUID(sessionUUID);
        DogDuplicationDetection.onSessionUUIDUpdate(dog, sessionUUID);
    }

    public OnlineDogLocationManager getOnlineDogsManager() {
        return this.onlineDogManager;
    }

    public void onServerStop(ServerStoppingEvent event) {
        this.onlineDogManager.onServerStop();
        this.grettingDogLimitMap.clear();
    }

    public void onServerStopped(ServerStoppedEvent event) {
        this.onlineDogManager.onServerStopped();
    }

    public static SavedDataType<DogLocationStorage> savedDataType_1_21_5(String name) {
        return LegacyNbtCodec_1_21_5.createSavedDataType(name, DogLocationStorage::new, DogLocationStorage::save, DogLocationStorage::load);
    }
}

